/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.generator;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import top.tanmw.generator.CodeGenerateUtils;
import top.tanmw.generator.FreeMarkerTemplateUtils;
import top.tanmw.generator.GeneratorModel;
import top.tanmw.generator.ProjectPattern;

public class Generator {
    public static void main(String[] args) throws Exception {
        String url = Generator.class.getClassLoader().getResource("generator.properties").getPath().toString();
        Generator.run(url);
    }

    public static void run(String url) throws Exception {
        Properties properties = Generator.getProperties(url);
        GeneratorModel model = new GeneratorModel();
        model.setUrl(properties.getProperty("url"));
        model.setDriver(properties.getProperty("driver"));
        model.setUser(properties.getProperty("user"));
        model.setPassword(properties.getProperty("password"));
        model.setDbName(properties.getProperty("dbName"));
        model.setTemplatePath(properties.getProperty("templatePath"));
        model.setAuthor(properties.getProperty("author"));
        model.setShowTablesSql(properties.getProperty("showTablesSql"));
        model.setShowTablesCommentSql(properties.getProperty("showTablesCommentSql"));
        model.setBasePath(properties.getProperty("basePath"));
        if (StrUtil.isBlank(model.getBasePath())) {
            String sp1 = System.getProperty("user.dir");
            model.setBasePath(sp1);
        }
        model.setProjectName(properties.getProperty("projectName"));
        if (StrUtil.isBlank(model.getProjectName())) {
            model.setProjectName("zenith");
        }
        model.setPackageName(properties.getProperty("packageName"));
        if (StrUtil.isBlank(model.getPackageName())) {
            model.setPackageName(model.getProjectName());
        }
        model.setPattern(properties.getProperty("pattern"));
        if (StrUtil.isBlank(model.getPattern())) {
            model.setPattern(ProjectPattern.MULTI.getDesc());
        }
        model.setExcludePrefix(properties.getProperty("excludePrefix"));
        model.setIncludeSet(properties.getProperty("includeSet"));
        model.setIncludeSetComment(properties.getProperty("includeSetComment"));
        model.setExcludeSet(properties.getProperty("excludeSet"));
        model.setReplace(false);
        if (StrUtil.isNotBlank(properties.getProperty("replace"))) {
            model.setReplace(Boolean.parseBoolean(properties.getProperty("replace")));
        }
        String fileType = properties.getProperty("fileType");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StrUtil.isBlank(fileType)) {
            for (int i2 = 0; i2 < 20; ++i2) {
                list.add(i2);
            }
        } else {
            String[] split;
            for (String str : split = fileType.split(",")) {
                if (!str.contains("-") && NumberUtil.isNumber(str)) {
                    list.add(Integer.parseInt(str));
                    continue;
                }
                String[] split1 = str.split("-");
                if (split1.length != 2 || !NumberUtil.isNumber(split1[0]) || !NumberUtil.isNumber(split1[1])) continue;
                for (int y2 = Integer.parseInt(split1[0]); y2 <= Integer.parseInt(split1[1]); ++y2) {
                    list.add(y2);
                }
            }
        }
        model.setFileType(list);
        CodeGenerateUtils codeGenerateUtils = new CodeGenerateUtils();
        codeGenerateUtils.init(model);
        codeGenerateUtils.initTableMapName();
        FreeMarkerTemplateUtils.init(model.getTemplatePath());
        codeGenerateUtils.generate();
    }

    public static Properties getProperties(String url) throws Exception {
        Properties properties = new Properties();
        File file = new File(url);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        properties.load(in);
        return properties;
    }
}

