/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class MapWrapper<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7524578042008586382L;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    private Map<K, V> raw;

    public MapWrapper(Supplier<Map<K, V>> mapFactory) {
        this(mapFactory.get());
    }

    public MapWrapper(Map<K, V> raw) {
        this.raw = raw;
    }

    public Map<K, V> getRaw() {
        return this.raw;
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.raw.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.raw.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.raw.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.raw.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.raw.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        this.raw.putAll(m3);
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public Collection<V> values() {
        return this.raw.values();
    }

    @Override
    public Set<K> keySet() {
        return this.raw.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.raw.entrySet();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MapWrapper that = (MapWrapper)o2;
        return Objects.equals(this.raw, that.raw);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.raw);
    }

    public String toString() {
        return this.raw.toString();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.raw.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.raw.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.raw.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.raw.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.raw.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.raw.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.raw.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.raw.getOrDefault(key, defaultValue);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.raw.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.raw.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.raw.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public MapWrapper<K, V> clone() throws CloneNotSupportedException {
        MapWrapper clone = (MapWrapper)super.clone();
        clone.raw = ObjectUtil.clone(this.raw);
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.raw);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.raw = (Map)in.readObject();
    }
}

