/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

@Deprecated
public class URLEncoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final URLEncoder DEFAULT = URLEncoder.createDefault();
    public static final URLEncoder PATH_SEGMENT = URLEncoder.createPathSegment();
    public static final URLEncoder FRAGMENT = URLEncoder.createFragment();
    public static final URLEncoder QUERY = URLEncoder.createQuery();
    public static final URLEncoder ALL = URLEncoder.createAll();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public static URLEncoder createDefault() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        return encoder;
    }

    public static URLEncoder createPathSegment() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter('@');
        return encoder;
    }

    public static URLEncoder createFragment() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        encoder.addSafeCharacter('?');
        return encoder;
    }

    public static URLEncoder createQuery() {
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(true);
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter('&');
        return encoder;
    }

    public static URLEncoder createAll() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        return encoder;
    }

    public URLEncoder() {
        this(new BitSet(256));
        this.addAlpha();
        this.addDigit();
    }

    private URLEncoder(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public void addSafeCharacter(char c2) {
        this.safeCharacters.set(c2);
    }

    public void removeSafeCharacter(char c2) {
        this.safeCharacters.clear(c2);
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public String encode(String path, Charset charset) {
        if (null == charset || StrUtil.isEmpty(path)) {
            return path;
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i2 = 0; i2 < path.length(); ++i2) {
            byte[] ba;
            char c2 = path.charAt(i2);
            if (this.safeCharacters.get(c2)) {
                rewrittenPath.append(c2);
                continue;
            }
            if (this.encodeSpaceAsPlus && c2 == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c2);
                writer.flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                HexUtil.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    private void addAlpha() {
        char i2;
        for (i2 = 'a'; i2 <= 'z'; i2 = (char)(i2 + '\u0001')) {
            this.addSafeCharacter(i2);
        }
        for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
            this.addSafeCharacter(i2);
        }
    }

    private void addDigit() {
        for (char i2 = '0'; i2 <= '9'; i2 = (char)(i2 + '\u0001')) {
            this.addSafeCharacter(i2);
        }
    }

    private static void addSubDelims(URLEncoder encoder) {
        encoder.addSafeCharacter('!');
        encoder.addSafeCharacter('$');
        encoder.addSafeCharacter('&');
        encoder.addSafeCharacter('\'');
        encoder.addSafeCharacter('(');
        encoder.addSafeCharacter(')');
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('+');
        encoder.addSafeCharacter(',');
        encoder.addSafeCharacter(';');
        encoder.addSafeCharacter('=');
    }
}

