/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.hash.CityHash;
import cn.hutool.core.lang.hash.MetroHash;
import cn.hutool.core.lang.hash.MurmurHash;
import cn.hutool.core.lang.hash.Number128;

public class HashUtil {
    public static int additiveHash(String key, int prime) {
        int hash = key.length();
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hash += key.charAt(i2);
        }
        return hash % prime;
    }

    public static int rotatingHash(String key, int prime) {
        int hash = key.length();
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hash = hash << 4 ^ hash >> 28 ^ key.charAt(i2);
        }
        return hash % prime;
    }

    public static int oneByOneHash(String key) {
        int hash = 0;
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hash += key.charAt(i2);
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static int bernstein(String key) {
        int hash = 0;
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hash = 33 * hash + key.charAt(i2);
        }
        return hash;
    }

    public static int universal(char[] key, int mask, int[] tab) {
        int hash = key.length;
        int len = key.length;
        for (int i2 = 0; i2 < len << 3; i2 += 8) {
            char k2 = key[i2 >> 3];
            if ((k2 & '\u0001') == 0) {
                hash ^= tab[i2];
            }
            if ((k2 & 2) == 0) {
                hash ^= tab[i2 + 1];
            }
            if ((k2 & 4) == 0) {
                hash ^= tab[i2 + 2];
            }
            if ((k2 & 8) == 0) {
                hash ^= tab[i2 + 3];
            }
            if ((k2 & 0x10) == 0) {
                hash ^= tab[i2 + 4];
            }
            if ((k2 & 0x20) == 0) {
                hash ^= tab[i2 + 5];
            }
            if ((k2 & 0x40) == 0) {
                hash ^= tab[i2 + 6];
            }
            if ((k2 & 0x80) != 0) continue;
            hash ^= tab[i2 + 7];
        }
        return hash & mask;
    }

    public static int zobrist(char[] key, int mask, int[][] tab) {
        int hash = key.length;
        for (int i2 = 0; i2 < key.length; ++i2) {
            hash ^= tab[i2][key[i2]];
        }
        return hash & mask;
    }

    public static int fnvHash(byte[] data) {
        int p2 = 16777619;
        int hash = -2128831035;
        for (byte b2 : data) {
            hash = (hash ^ b2) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return Math.abs(hash);
    }

    public static int fnvHash(String data) {
        int p2 = 16777619;
        int hash = -2128831035;
        for (int i2 = 0; i2 < data.length(); ++i2) {
            hash = (hash ^ data.charAt(i2)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return Math.abs(hash);
    }

    public static int intHash(int key) {
        key += ~(key << 15);
        key ^= key >>> 10;
        key += key << 3;
        key ^= key >>> 6;
        key += ~(key << 11);
        key ^= key >>> 16;
        return key;
    }

    public static int rsHash(String str) {
        int b2 = 378551;
        int a2 = 63689;
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash = hash * a2 + str.charAt(i2);
            a2 *= b2;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int jsHash(String str) {
        int hash = 1315423911;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash ^= (hash << 5) + str.charAt(i2) + (hash >> 2);
        }
        return Math.abs(hash) & Integer.MAX_VALUE;
    }

    public static int pjwHash(String str) {
        int bitsInUnsignedInt = 32;
        int threeQuarters = bitsInUnsignedInt * 3 / 4;
        int oneEighth = bitsInUnsignedInt / 8;
        int highBits = -1 << bitsInUnsignedInt - oneEighth;
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int test = (hash = (hash << oneEighth) + str.charAt(i2)) & highBits;
            if (test == 0) continue;
            hash = (hash ^ test >> threeQuarters) & ~highBits;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int elfHash(String str) {
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int x2 = (int)((long)(hash = (hash << 4) + str.charAt(i2)) & 0xF0000000L);
            if (x2 == 0) continue;
            hash ^= x2 >> 24;
            hash &= ~x2;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int bkdrHash(String str) {
        int seed = 131;
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash = hash * seed + str.charAt(i2);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int sdbmHash(String str) {
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash = str.charAt(i2) + (hash << 6) + (hash << 16) - hash;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int djbHash(String str) {
        int hash = 5381;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash = (hash << 5) + hash + str.charAt(i2);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int dekHash(String str) {
        int hash = str.length();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash = hash << 5 ^ hash >> 27 ^ str.charAt(i2);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int apHash(String str) {
        int hash = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            hash ^= (i2 & 1) == 0 ? hash << 7 ^ str.charAt(i2) ^ hash >> 3 : ~(hash << 11 ^ str.charAt(i2) ^ hash >> 5);
        }
        return hash;
    }

    public static long tianlHash(String str) {
        int iLength = str.length();
        if (iLength == 0) {
            return 0L;
        }
        long hash = iLength <= 256 ? 0x1000000L * (long)(iLength - 1) : 0xFF000000L;
        if (iLength <= 96) {
            for (int i2 = 1; i2 <= iLength; ++i2) {
                char ucChar = str.charAt(i2 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i2 * (long)ucChar * (long)ucChar + 5L * (long)i2 * (long)ucChar + 7L * (long)i2 + (long)(11 * ucChar)) % 0x1000000L;
            }
        } else {
            for (int i3 = 1; i3 <= 96; ++i3) {
                char ucChar = str.charAt(i3 + iLength - 96 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i3 * (long)ucChar * (long)ucChar + 5L * (long)i3 * (long)ucChar + 7L * (long)i3 + (long)(11 * ucChar)) % 0x1000000L;
            }
        }
        if (hash < 0L) {
            hash *= -1L;
        }
        return hash;
    }

    public static int javaDefaultHash(String str) {
        int h2 = 0;
        int off = 0;
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            h2 = 31 * h2 + str.charAt(off++);
        }
        return h2;
    }

    public static long mixHash(String str) {
        long hash = str.hashCode();
        hash <<= 32;
        return hash |= (long)HashUtil.fnvHash(str);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static int murmur32(byte[] data) {
        return MurmurHash.hash32(data);
    }

    public static long murmur64(byte[] data) {
        return MurmurHash.hash64(data);
    }

    public static long[] murmur128(byte[] data) {
        return MurmurHash.hash128(data);
    }

    public static int cityHash32(byte[] data) {
        return CityHash.hash32(data);
    }

    public static long cityHash64(byte[] data, long seed) {
        return CityHash.hash64(data, seed);
    }

    public static long cityHash64(byte[] data, long seed0, long seed1) {
        return CityHash.hash64(data, seed0, seed1);
    }

    public static long cityHash64(byte[] data) {
        return CityHash.hash64(data);
    }

    public static long[] cityHash128(byte[] data) {
        return CityHash.hash128(data).getLongArray();
    }

    public static long[] cityHash128(byte[] data, Number128 seed) {
        return CityHash.hash128(data, seed).getLongArray();
    }

    public static long metroHash64(byte[] data, long seed) {
        return MetroHash.hash64(data, seed);
    }

    public static long metroHash64(byte[] data) {
        return MetroHash.hash64(data);
    }

    public static long[] metroHash128(byte[] data, long seed) {
        return MetroHash.hash128(data, seed).getLongArray();
    }

    public static long[] metroHash128(byte[] data) {
        return MetroHash.hash128(data).getLongArray();
    }

    public static long hfHash(String data) {
        int length = data.length();
        long hash = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            hash += (long)data.charAt(i2) * 3L * (long)i2;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        return hash;
    }

    public static long hfIpHash(String data) {
        int length = data.length();
        long hash = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            hash += (long)(data.charAt(i2 % 4) ^ data.charAt(i2));
        }
        return hash;
    }
}

