/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.generator.config.IConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectionConfig.class);
    private BiConsumer<TableInfo, Map<String, Object>> beforeOutputFileBiConsumer;
    private Map<String, Object> customMap = new HashMap<String, Object>();
    @Deprecated
    private Map<String, String> customFile = new HashMap<String, String>();
    private List<CustomFile> customFiles = new ArrayList<CustomFile>();
    @Deprecated
    private boolean fileOverride;

    @NotNull
    public void beforeOutputFile(TableInfo tableInfo, Map<String, Object> objectMap) {
        if (!this.customMap.isEmpty()) {
            objectMap.putAll(this.customMap);
        }
        if (null != this.beforeOutputFileBiConsumer) {
            this.beforeOutputFileBiConsumer.accept(tableInfo, objectMap);
        }
    }

    @NotNull
    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    @Deprecated
    @NotNull
    public Map<String, String> getCustomFile() {
        return this.customFile;
    }

    @NotNull
    public List<CustomFile> getCustomFiles() {
        return this.customFiles;
    }

    @Deprecated
    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public static class Builder
    implements IConfigBuilder<InjectionConfig> {
        private final InjectionConfig injectionConfig = new InjectionConfig();

        public Builder beforeOutputFile(@NotNull BiConsumer<TableInfo, Map<String, Object>> biConsumer) {
            this.injectionConfig.beforeOutputFileBiConsumer = biConsumer;
            return this;
        }

        public Builder customMap(@NotNull Map<String, Object> customMap) {
            this.injectionConfig.customMap = customMap;
            return this;
        }

        public Builder customFile(@NotNull Map<String, String> customFile) {
            return this.customFile(customFile.entrySet().stream().map(e2 -> new CustomFile.Builder().fileName((String)e2.getKey()).templatePath((String)e2.getValue()).build()).collect(Collectors.toList()));
        }

        public Builder customFile(@NotNull CustomFile customFile) {
            this.injectionConfig.customFiles.add(customFile);
            return this;
        }

        public Builder customFile(@NotNull List<CustomFile> customFiles) {
            this.injectionConfig.customFiles.addAll(customFiles);
            return this;
        }

        public Builder customFile(Consumer<CustomFile.Builder> consumer) {
            CustomFile.Builder builder = new CustomFile.Builder();
            consumer.accept(builder);
            this.injectionConfig.customFiles.add(builder.build());
            return this;
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.injectionConfig.fileOverride = true;
            return this;
        }

        @Override
        public InjectionConfig build() {
            return this.injectionConfig;
        }
    }
}

