/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Controller;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.builder.Mapper;
import com.baomidou.mybatisplus.generator.config.builder.Service;
import com.baomidou.mybatisplus.generator.config.po.LikeTable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrategyConfig {
    private boolean isCapitalMode;
    private boolean skipView;
    private final Set<String> tablePrefix = new HashSet<String>();
    private final Set<String> tableSuffix = new HashSet<String>();
    private final Set<String> fieldPrefix = new HashSet<String>();
    private final Set<String> fieldSuffix = new HashSet<String>();
    private final Set<String> include = new HashSet<String>();
    private final Set<String> exclude = new HashSet<String>();
    private boolean enableSqlFilter = true;
    private boolean enableSchema;
    private LikeTable likeTable;
    private LikeTable notLikeTable;
    private final Entity.Builder entityBuilder = new Entity.Builder(this);
    private final Controller.Builder controllerBuilder = new Controller.Builder(this);
    private final Mapper.Builder mapperBuilder = new Mapper.Builder(this);
    private final Service.Builder serviceBuilder = new Service.Builder(this);
    private Entity entity;
    private Controller controller;
    private Mapper mapper;
    private Service service;

    private StrategyConfig() {
    }

    @NotNull
    public Entity.Builder entityBuilder() {
        return this.entityBuilder;
    }

    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = this.entityBuilder.get();
        }
        return this.entity;
    }

    @NotNull
    public Controller.Builder controllerBuilder() {
        return this.controllerBuilder;
    }

    @NotNull
    public Controller controller() {
        if (this.controller == null) {
            this.controller = this.controllerBuilder.get();
        }
        return this.controller;
    }

    @NotNull
    public Mapper.Builder mapperBuilder() {
        return this.mapperBuilder;
    }

    @NotNull
    public Mapper mapper() {
        if (this.mapper == null) {
            this.mapper = this.mapperBuilder.get();
        }
        return this.mapper;
    }

    @NotNull
    public Service.Builder serviceBuilder() {
        return this.serviceBuilder;
    }

    @NotNull
    public Service service() {
        if (this.service == null) {
            this.service = this.serviceBuilder.get();
        }
        return this.service;
    }

    public boolean isCapitalModeNaming(@NotNull String word) {
        return this.isCapitalMode && StringUtils.isCapitalMode(word);
    }

    public boolean startsWithTablePrefix(@NotNull String tableName) {
        return this.tablePrefix.stream().anyMatch(tableName::startsWith);
    }

    public void validate() {
        boolean isExclude;
        boolean isInclude = this.getInclude().size() > 0;
        boolean bl = isExclude = this.getExclude().size() > 0;
        if (isInclude && isExclude) {
            throw new IllegalArgumentException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        if (this.getNotLikeTable() != null && this.getLikeTable() != null) {
            throw new IllegalArgumentException("<strategy> \u6807\u7b7e\u4e2d <likeTable> \u4e0e <notLikeTable> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
    }

    public boolean matchIncludeTable(@NotNull String tableName) {
        return this.matchTable(tableName, this.getInclude());
    }

    public boolean matchExcludeTable(@NotNull String tableName) {
        return this.matchTable(tableName, this.getExclude());
    }

    private boolean matchTable(@NotNull String tableName, @NotNull Set<String> matchTables) {
        return matchTables.stream().anyMatch(t2 -> this.tableNameMatches((String)t2, tableName));
    }

    private boolean tableNameMatches(@NotNull String matchTableName, @NotNull String dbTableName) {
        return matchTableName.equalsIgnoreCase(dbTableName) || StringUtils.matches(matchTableName, dbTableName);
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public boolean isSkipView() {
        return this.skipView;
    }

    @NotNull
    public Set<String> getTablePrefix() {
        return this.tablePrefix;
    }

    @NotNull
    public Set<String> getTableSuffix() {
        return this.tableSuffix;
    }

    @NotNull
    public Set<String> getFieldPrefix() {
        return this.fieldPrefix;
    }

    @NotNull
    public Set<String> getFieldSuffix() {
        return this.fieldSuffix;
    }

    @NotNull
    public Set<String> getInclude() {
        return this.include;
    }

    @NotNull
    public Set<String> getExclude() {
        return this.exclude;
    }

    public boolean isEnableSqlFilter() {
        return this.enableSqlFilter;
    }

    public boolean isEnableSchema() {
        return this.enableSchema;
    }

    @Nullable
    public LikeTable getLikeTable() {
        return this.likeTable;
    }

    @Nullable
    public LikeTable getNotLikeTable() {
        return this.notLikeTable;
    }

    public static class Builder
    extends BaseBuilder {
        private final StrategyConfig strategyConfig = super.build();

        public Builder() {
            super(new StrategyConfig());
        }

        public Builder enableCapitalMode() {
            this.strategyConfig.isCapitalMode = true;
            return this;
        }

        public Builder enableSkipView() {
            this.strategyConfig.skipView = true;
            return this;
        }

        public Builder disableSqlFilter() {
            this.strategyConfig.enableSqlFilter = false;
            return this;
        }

        public Builder enableSchema() {
            this.strategyConfig.enableSchema = true;
            return this;
        }

        public Builder addTablePrefix(String ... tablePrefix) {
            return this.addTablePrefix(Arrays.asList(tablePrefix));
        }

        public Builder addTablePrefix(@NotNull List<String> tablePrefixList) {
            this.strategyConfig.tablePrefix.addAll(tablePrefixList);
            return this;
        }

        public Builder addTableSuffix(String ... tableSuffix) {
            return this.addTableSuffix(Arrays.asList(tableSuffix));
        }

        public Builder addTableSuffix(@NotNull List<String> tableSuffixList) {
            this.strategyConfig.tableSuffix.addAll(tableSuffixList);
            return this;
        }

        public Builder addFieldPrefix(String ... fieldPrefix) {
            return this.addFieldPrefix(Arrays.asList(fieldPrefix));
        }

        public Builder addFieldPrefix(@NotNull List<String> fieldPrefix) {
            this.strategyConfig.fieldPrefix.addAll(fieldPrefix);
            return this;
        }

        public Builder addFieldSuffix(String ... fieldSuffix) {
            return this.addFieldSuffix(Arrays.asList(fieldSuffix));
        }

        public Builder addFieldSuffix(@NotNull List<String> fieldSuffixList) {
            this.strategyConfig.fieldSuffix.addAll(fieldSuffixList);
            return this;
        }

        public Builder addInclude(String ... include) {
            this.strategyConfig.include.addAll(Arrays.asList(include));
            return this;
        }

        public Builder addInclude(@NotNull List<String> includes) {
            this.strategyConfig.include.addAll(includes);
            return this;
        }

        public Builder addInclude(@NotNull String include) {
            this.strategyConfig.include.addAll(Arrays.asList(include.split(",")));
            return this;
        }

        public Builder addExclude(String ... exclude) {
            return this.addExclude(Arrays.asList(exclude));
        }

        public Builder addExclude(@NotNull List<String> excludeList) {
            this.strategyConfig.exclude.addAll(excludeList);
            return this;
        }

        public Builder likeTable(@NotNull LikeTable likeTable) {
            this.strategyConfig.likeTable = likeTable;
            return this;
        }

        public Builder notLikeTable(@NotNull LikeTable notLikeTable) {
            this.strategyConfig.notLikeTable = notLikeTable;
            return this;
        }

        @Override
        @NotNull
        public StrategyConfig build() {
            this.strategyConfig.validate();
            return this.strategyConfig;
        }
    }
}

