/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.ServerVersion;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte element : data) {
            sb.append(Integer.toHexString(element >> 4 & 0xF));
            sb.append(Integer.toHexString(element & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        return str.getBytes();
    }

    public static byte[] encode(String str, String encoding) throws UnsupportedEncodingException {
        return str.getBytes(encoding);
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(value.length() * 11 / 10);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i2 = 0; i2 < value.length(); ++i2) {
                    char ch = value.charAt(i2);
                    if (ch == '\u0000') {
                        throw new KSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch);
                }
            } else {
                for (int i3 = 0; i3 < value.length(); ++i3) {
                    char ch = value.charAt(i3);
                    if (ch == '\u0000') {
                        throw new KSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\\' || ch == '\'') {
                        sbuf.append(ch);
                    }
                    sbuf.append(ch);
                }
            }
        }
        catch (IOException e2) {
            throw new KSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e2);
        }
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + value.length() * 11 / 10);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value) throws SQLException {
        try {
            sbuf.append('\"');
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char ch = value.charAt(i2);
                if (ch == '\u0000') {
                    throw new KSQLException(GT.tr("Zero bytes may not occur in identifiers.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\"') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
            sbuf.append('\"');
        }
        catch (IOException e2) {
            throw new KSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e2);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        return ServerVersion.parseServerVersionStr(serverVersion);
    }
}

