/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.executor.AbstractExecuteCommand;
import com.kingbase8.dispatcher.executor.DispatchAbstractStatement;
import com.kingbase8.dispatcher.executor.command.StatmentCommand;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DispatchStatementV2
extends DispatchAbstractStatement
implements Statement {
    protected boolean isClosed = false;
    private boolean closeOnCompletion = false;

    public DispatchStatementV2(DispatchConnection con) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand();
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency);
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeQuery(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t2) throws SQLException {
                KbResultSet brs;
                BaseConnection conn = (BaseConnection)t2.getConnection();
                ResultSet rs = t2.executeQuery(sql);
                if (conn.isSlave() && conn.isZeroResend() && (brs = (KbResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new KSQLException("resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.executeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public void close() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.close()";
            }

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.close();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMaxFieldSize()";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getMaxFieldSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxFieldSize(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setMaxFieldSize(" + max + ")";
            }

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setMaxFieldSize(max);
                DispatchStatementV2.this.maxFieldSize = max;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getMaxRows() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getMaxRows();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxRows(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setMaxRows(max);
                DispatchStatementV2.this.maxrows = max;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public void setEscapeProcessing(final boolean enable) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setEscapeProcessing(enable);
                DispatchStatementV2.this.replaceProcessingEnabled = enable;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getQueryTimeout();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setQueryTimeout(final int seconds) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setQueryTimeout(seconds);
                DispatchStatementV2.this.timeout = seconds;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public void cancel() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.cancel();
                return null;
            }
        };
        this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AbstractExecuteCommand<SQLWarning> ec = new AbstractExecuteCommand<SQLWarning>(){

            @Override
            public SQLWarning execute(Statement t2) throws SQLException {
                return t2.getWarnings();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void clearWarnings() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.clearWarnings();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setCursorName(final String name) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setCursorName(name);
                DispatchStatementV2.this.cursor = name;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.execute(sql);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getResultSet()";
            }

            @Override
            public ResultSet execute(Statement t2) throws SQLException {
                return t2.getResultSet();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getUpdateCount()";
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.getMoreResults();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void setFetchDirection(final int direction) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setFetchDirection(direction);
                DispatchStatementV2.this.fetchdirection = direction;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getFetchDirection();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setFetchSize(final int rows) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.setFetchSize(rows);
                DispatchStatementV2.this.fetchSize = rows;
                return null;
            }
        };
        this.executeTemplet(ec, 2);
    }

    @Override
    public int getFetchSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getFetchSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getResultSetConcurrency();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public int getResultSetType() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getResultSetType();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void addBatch(final String sql) throws SQLException {
        if (this.sqlType == null || !this.sqlType.equalsIgnoreCase("insert or delete or update") && !this.sqlType.equalsIgnoreCase("in transaction")) {
            this.getExecuteType(sql);
        }
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.addBatch(" + sql + ")";
            }

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.addBatch(sql);
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public void clearBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t2) throws SQLException {
                t2.clearBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t2) throws SQLException {
                return t2.executeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dispatchConnection;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.getMoreResults(current);
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getGeneratedKeys()";
            }

            @Override
            public ResultSet execute(Statement t2) throws SQLException {
                return t2.getGeneratedKeys();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.executeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.executeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.executeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.execute(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.execute(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t2) throws SQLException {
                return t2.execute(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t2) throws SQLException {
                return t2.getResultSetHoldability();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    protected void initStatement(Statement statement) throws SQLException {
        if (this.maxFieldSize != null) {
            statement.setMaxFieldSize(this.maxFieldSize);
        }
        if (this.fetchSize != null) {
            statement.setFetchSize(this.fetchSize);
        }
        if (this.maxrows != null) {
            statement.setMaxRows(this.maxrows);
        }
        if (this.replaceProcessingEnabled != null) {
            statement.setEscapeProcessing(this.replaceProcessingEnabled);
        }
        if (this.fetchdirection != null) {
            statement.setFetchDirection(this.fetchdirection);
        }
        if (this.timeout != null) {
            statement.setQueryTimeout(this.timeout);
        }
        if (this.cursor != null) {
            statement.setCursorName(this.cursor);
        }
    }

    @Override
    protected boolean expectionHandler(SQLException e2, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e2)) {
            changeSuccess = true;
        }
        return changeSuccess;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }
}

