/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBbox
extends KBobject
implements KBBinaryObject,
Serializable,
Cloneable {
    public KBpoint[] point = new KBpoint[2];

    public KBbox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new KBpoint(x1, y1);
        this.point[1] = new KBpoint(x2, y2);
    }

    public KBbox(KBpoint p1, KBpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public KBbox(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public KBbox() {
        this.setType("BOX");
    }

    @Override
    public void setValue(String value) throws SQLException {
        KBtokenizer t2 = new KBtokenizer(value, ',');
        if (t2.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, value), KSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new KBpoint(t2.getToken(0));
        this.point[1] = new KBpoint(t2.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b2, int offset) {
        this.point[0] = new KBpoint();
        this.point[0].setByteValue(b2, offset);
        this.point[1] = new KBpoint();
        this.point[1].setByteValue(b2, offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBbox) {
            KBbox p2 = (KBbox)obj;
            if (p2.point[0].equals(this.point[0]) && p2.point[1].equals(this.point[1])) {
                return true;
            }
            if (p2.point[0].equals(this.point[1]) && p2.point[1].equals(this.point[0])) {
                return true;
            }
            if (p2.point[0].x == this.point[0].x && p2.point[0].y == this.point[1].y && p2.point[1].x == this.point[1].x && p2.point[1].y == this.point[0].y) {
                return true;
            }
            if (p2.point[0].x == this.point[1].x && p2.point[0].y == this.point[0].y && p2.point[1].x == this.point[0].x && p2.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBbox newKBbox = (KBbox)super.clone();
        if (newKBbox.point != null) {
            newKBbox.point = (KBpoint[])newKBbox.point.clone();
            for (int i2 = 0; i2 < newKBbox.point.length; ++i2) {
                if (newKBbox.point[i2] == null) continue;
                newKBbox.point[i2] = (KBpoint)newKBbox.point[i2].clone();
            }
        }
        return newKBbox;
    }

    @Override
    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        this.point[0].toBytes(bytes, offset);
        this.point[1].toBytes(bytes, offset + this.point[0].lengthInBytes());
    }
}

