/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBcircle
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint center;
    public double radius;

    public KBcircle(double x2, double y2, double r2) {
        this(new KBpoint(x2, y2), r2);
    }

    public KBcircle(KBpoint c2, double r2) {
        this();
        this.center = c2;
        this.radius = r2;
    }

    public KBcircle(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public KBcircle() {
        this.setType("CIRCLE");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        KBtokenizer t2 = new KBtokenizer(KBtokenizer.removeAngle(s2), ',');
        if (t2.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new KBpoint(t2.getToken(0));
            this.radius = Double.parseDouble(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH, (Throwable)e2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBcircle) {
            KBcircle p2 = (KBcircle)obj;
            return p2.center.equals(this.center) && p2.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v2 = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v2 ^ v2 >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBcircle newKBcircle = (KBcircle)super.clone();
        if (newKBcircle.center != null) {
            newKBcircle.center = (KBpoint)newKBcircle.center.clone();
        }
        return newKBcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

