/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBlseg;
import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBline
extends KBobject
implements Serializable,
Cloneable {
    public double a;
    public double b;
    public double c;

    public KBline(double a2, double b2, double c2) {
        this();
        this.a = a2;
        this.b = b2;
        this.c = c2;
    }

    public KBline(double x1, double y1, double x2, double y2) {
        this();
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public KBline(KBpoint p1, KBpoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public KBline(KBlseg lseg) {
        this(lseg.point[0], lseg.point[1]);
    }

    public KBline(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public KBline() {
        this.setType("LINE");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        if (s2.trim().startsWith("{")) {
            KBtokenizer t2 = new KBtokenizer(KBtokenizer.removeCurlyBrace(s2), ',');
            if (t2.getSize() != 3) {
                throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(t2.getToken(0));
            this.b = Double.parseDouble(t2.getToken(1));
            this.c = Double.parseDouble(t2.getToken(2));
        } else if (s2.trim().startsWith("[")) {
            KBtokenizer t3 = new KBtokenizer(KBtokenizer.removeBox(s2), ',');
            if (t3.getSize() != 2) {
                throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), KSQLState.DATA_TYPE_MISMATCH);
            }
            KBpoint point1 = new KBpoint(t3.getToken(0));
            KBpoint point2 = new KBpoint(t3.getToken(1));
            this.a = point2.x - point1.x;
            this.b = point2.y - point1.y;
            this.c = point1.y;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        KBline pGline = (KBline)obj;
        return Double.compare(pGline.a, this.a) == 0 && Double.compare(pGline.b, this.b) == 0 && Double.compare(pGline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String getValue() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

