/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpolygon
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] points;

    public KBpolygon(KBpoint[] points) {
        this();
        this.points = points;
    }

    public KBpolygon(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public KBpolygon() {
        this.setType("POLYGON");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        KBtokenizer t2 = new KBtokenizer(KBtokenizer.removePara(s2), ',');
        int npoints = t2.getSize();
        this.points = new KBpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new KBpoint(t2.getToken(p2));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBpolygon) {
            KBpolygon p2 = (KBpolygon)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2].equals(p2.points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            hash ^= this.points[i2].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBpolygon newKBpolygon = (KBpolygon)super.clone();
        if (newKBpolygon.points != null) {
            newKBpolygon.points = (KBpoint[])newKBpolygon.points.clone();
            for (int i2 = 0; i2 < newKBpolygon.points.length; ++i2) {
                if (newKBpolygon.points[i2] == null) continue;
                newKBpolygon.points[i2] = (KBpoint)newKBpolygon.points[i2].clone();
            }
        }
        return newKBpolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b2 = new StringBuilder();
        b2.append("(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(this.points[p2].toString());
        }
        b2.append(")");
        return b2.toString();
    }
}

