/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobNewOutputStream
extends OutputStream {
    private Blob lo;
    private byte[] buf;
    private int bsize;
    private int bpos;
    private int blobpos;

    public BlobNewOutputStream(Blob lo, int pos) {
        this.lo = lo;
        this.blobpos = pos;
        this.bsize = 1024;
        this.buf = new byte[this.bsize];
        this.bpos = 0;
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos >= this.bsize) {
                this.lo.setBytes(this.blobpos, this.buf);
                this.blobpos += this.buf.length;
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)b2;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (off == 0 && len == buf.length) {
                this.lo.setBytes(this.blobpos, buf);
                this.blobpos += buf.length;
            } else {
                this.lo.setBytes(this.blobpos, buf, off, len);
                this.blobpos += len;
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            if (this.bpos > 0) {
                this.lo.setBytes(this.blobpos, this.buf, 0, this.bpos);
                this.blobpos += this.bpos;
            }
            this.bpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lo != null) {
            this.flush();
            this.lo = null;
        }
    }

    private void checkClosed() throws IOException {
        if (this.lo == null) {
            throw new IOException("BlobNewOutputStream is closed");
        }
    }
}

