/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.replication;

import java.nio.ByteBuffer;

public final class LogSequenceNumber {
    public static final LogSequenceNumber INVALID_LSN = LogSequenceNumber.valueOf(0L);
    private final long value;

    private LogSequenceNumber(long value) {
        this.value = value;
    }

    public static LogSequenceNumber valueOf(long value) {
        return new LogSequenceNumber(value);
    }

    public static LogSequenceNumber valueOf(String strValue) {
        int slashIndex = strValue.lastIndexOf(47);
        if (slashIndex <= 0) {
            return INVALID_LSN;
        }
        String logicalXLogStr = strValue.substring(0, slashIndex);
        int logicalXlog = (int)Long.parseLong(logicalXLogStr, 16);
        String segmentStr = strValue.substring(slashIndex + 1, strValue.length());
        int segment = (int)Long.parseLong(segmentStr, 16);
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(logicalXlog);
        buf.putInt(segment);
        buf.position(0);
        long value = buf.getLong();
        return LogSequenceNumber.valueOf(value);
    }

    public long asLong() {
        return this.value;
    }

    public String asString() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(this.value);
        buf.position(0);
        int logicalXlog = buf.getInt();
        int segment = buf.getInt();
        return String.format("%X/%X", logicalXlog, segment);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LogSequenceNumber that = (LogSequenceNumber)o2;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return "LSN{" + this.asString() + '}';
    }
}

