/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.ssl.jdbc4.LibPQFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.ObjectFactory;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    public static void convert(KBStream stream, Properties info) throws KSQLException, IOException {
        SSLSocket newConnection;
        SSLSocketFactory factory;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl");
        String sslmode = KBProperty.SSL_MODE.get(info);
        String classname = KBProperty.SSL_FACTORY.get(info);
        if (classname == null) {
            factory = sslmode != null ? new LibPQFactory(info) : (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            try {
                factory = (SSLSocketFactory)MakeSSL.instantiate(classname, info, true, KBProperty.SSL_FACTORY_ARG.get(info));
            }
            catch (Exception e2) {
                throw new KSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), KSQLState.CONNECTION_FAILURE, (Throwable)e2);
            }
        }
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            if (factory instanceof LibPQFactory) {
                ((LibPQFactory)factory).throwKeyManagerException();
            }
            throw new KSQLException(GT.tr("SSL error: {0}", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        String sslhostnameverifier = KBProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier != null) {
            HostnameVerifier hvn;
            try {
                hvn = (HostnameVerifier)MakeSSL.instantiate(sslhostnameverifier, info, false, null);
            }
            catch (Exception e3) {
                throw new KSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), KSQLState.CONNECTION_FAILURE, (Throwable)e3);
            }
            if (!hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
                throw new KSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), KSQLState.CONNECTION_FAILURE);
            }
        } else if ("verify-full".equals(sslmode) && factory instanceof LibPQFactory && !((LibPQFactory)factory).verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            throw new KSQLException(GT.tr("The hostname {0} could not be verified.", stream.getHostSpec().getHost()), KSQLState.CONNECTION_FAILURE);
        }
        stream.changeSocket(newConnection);
    }
}

