/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public class DmBooleanBinder
extends DmBinder {
    public DmBooleanBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 5;
        this.recPrec = 1;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        ret = this.isDiffParamObjectType() && !(obj instanceof Boolean) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc) : DmBooleanBinder.toDbBytes((Boolean)obj, this.destDType, this.destPrec, this.destScale, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(boolean x2, int destDType, int destPrec, int destScale, String serverEncoding) throws SQLException {
        int value = x2 ? 1 : 0;
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 3: 
                case 13: {
                    ret = Convertion.booleanToByteArray(x2);
                    break;
                }
                case 5: {
                    ret = Convertion.byteToByteArray((byte)value);
                    break;
                }
                case 6: {
                    ret = Convertion.shortToByteArray((short)value);
                    break;
                }
                case 7: {
                    ret = Convertion.intToByteArray(value);
                    break;
                }
                case 8: {
                    ret = Convertion.longToByteArray(value);
                    break;
                }
                case 10: {
                    ret = Convertion.floatToByteArray(value);
                    break;
                }
                case 11: {
                    ret = Convertion.doubleToByteArray(value);
                    break;
                }
                case 9: {
                    ret = Convertion.BigDecimalToByteArray(String.valueOf(value), destPrec, destScale);
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(value), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(value), destPrec, destDType, serverEncoding);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return DmBooleanBinder.checkParamData(ret, destDType, destPrec, serverEncoding);
    }
}

