/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public class DmByteArrBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmByteArrBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 18;
        this.recPrec = 8188;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        if (this.isDiffParamObjectType() && !(obj instanceof byte[])) {
            ret = this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc);
        } else {
            byte[] x2 = (byte[])obj;
            if (this.destDType == 12 ? x2.length > 2048 : this.destDType == 19 && x2.length * 2 > 2048) {
                return -1;
            }
            ret = DmByteArrBinder.toDbBytes(x2, this.destDType, this.destPrec, this.destScale, serverEncoding);
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(byte[] x2, int destDType, int destPrec, int destScale, String serverEncoding) throws SQLException {
        byte[] bs = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 17: {
                    bs = x2;
                    break;
                }
                case 18: {
                    bs = x2;
                    break;
                }
                case 12: {
                    bs = x2;
                    break;
                }
                case 19: {
                    bs = Convertion.binaryArrToString(x2, destPrec, destDType);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    bs = Convertion.binaryArrToString(x2, destPrec, destDType);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return DmByteArrBinder.checkParamData(bs, destDType, destPrec, serverEncoding);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        int readLen;
        byte[] x2;
        int maxLen = 16000;
        if (this.destDType == 19) {
            maxLen = 8000;
        }
        if (this.offset_var >= (x2 = (byte[])this.pstmt.getParamObject(irow, icol)).length) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 0;
        }
        int retLen = 0;
        int n2 = readLen = x2.length - this.offset_var > maxLen ? maxLen : x2.length - this.offset_var;
        if (this.destDType == 12) {
            retLen = lobMsg.appendOffRowBytes(x2, this.offset_var, readLen, this.new_lob_flag, -1);
        } else if (this.destDType == 19) {
            byte[] cvt = Convertion.binaryArrToClob_bin(x2, this.offset_var, readLen);
            retLen = lobMsg.appendOffRowBytes(cvt, 0, cvt.length, this.new_lob_flag, -1);
        }
        this.offset_var += readLen;
        return retLen;
    }
}

