/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

public class RwCounter {
    private int primaryTrxPercent = 25;
    private long NTRX_P = 0L;
    private long NTRX_S = 0L;

    public RwCounter(int percent) {
        this.primaryTrxPercent = percent;
    }

    public synchronized int count(int dest) {
        int ret = 1;
        if (this.NTRX_P >= Long.MAX_VALUE || this.NTRX_S >= Long.MAX_VALUE) {
            long min2 = this.NTRX_P > this.NTRX_S ? this.NTRX_S : this.NTRX_P;
            this.NTRX_P /= min2;
            this.NTRX_S /= min2;
        }
        if (dest == 1) {
            ++this.NTRX_P;
            ret = 1;
        } else if (dest == 0) {
            ++this.NTRX_S;
            ret = 0;
        } else if ((double)this.NTRX_P < (double)((this.NTRX_S + this.NTRX_P) * (long)this.primaryTrxPercent) / 100.0) {
            ++this.NTRX_P;
            ret = 1;
        } else {
            ++this.NTRX_S;
            ret = 0;
        }
        return ret;
    }

    public int getPrimaryTrxPercent() {
        return this.primaryTrxPercent;
    }

    public void setPrimaryTrxPercent(int primaryTrxPercent) {
        this.primaryTrxPercent = primaryTrxPercent;
    }
}

