/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.ConnClientAttr;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.util.StringUtil;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DmDriver_bs {
    private final ResourceBundle res = DmSvcConf.res;

    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = this.parseUrlBeforeConnect(url, info);
        if (props != null) {
            return DmDriver_bs.createConnection(url, props);
        }
        return null;
    }

    public Properties parseUrlBeforeConnect(String url, Properties info) throws SQLException {
        Properties props;
        if (StringUtil.isNotEmpty(url)) {
            String newAddress;
            int startIdx = url.indexOf("//");
            int endIdx = url.indexOf("?");
            startIdx = startIdx != -1 ? startIdx + 2 : startIdx;
            int n2 = endIdx = endIdx == -1 ? url.length() : endIdx;
            if (startIdx != -1 && StringUtil.isNotEmpty(newAddress = DmSvcConf.addressRemap(url.substring(startIdx, endIdx).trim()))) {
                url = String.valueOf(url.substring(0, startIdx)) + newAddress + url.substring(endIdx);
            }
        }
        if ((props = DmDriver_bs.parseURL(url, info)) != null) {
            ConnClientAttr.initLogProps(props);
            ConnClientAttr.initStatProps(props);
        }
        return props;
    }

    public static DmdbConnection_bs createConnection(String url, Properties props) throws SQLException {
        DmdbConnection_bs conn = new DmdbConnection_bs(url, props);
        return conn;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return DmDriver_bs.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if ((info = DmDriver_bs.parseURL(url, info)) == null) {
            DBError.throwSQLException(20018);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host"));
        hostProp.required = true;
        hostProp.description = this.res.getString("description.host");
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port", String.valueOf(5236)));
        portProp.required = false;
        portProp.description = this.res.getString("desciption.port");
        DriverPropertyInfo dbProp = new DriverPropertyInfo("dbname", info.getProperty("dbname"));
        dbProp.required = false;
        dbProp.description = this.res.getString("desciption.dbname");
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = this.res.getString("desciption.user");
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = this.res.getString("desciption.pwd");
        DriverPropertyInfo socketTimeout = new DriverPropertyInfo("socketTimeout", info.getProperty("socketTimeout", "0"));
        socketTimeout.required = false;
        socketTimeout.description = this.res.getString("desciption.time.socket");
        DriverPropertyInfo continueBatchOnError = new DriverPropertyInfo("continueBatchOnError", info.getProperty("continueBatchOnError", "false"));
        continueBatchOnError.required = false;
        continueBatchOnError.description = this.res.getString("desciption.execute.continue");
        DriverPropertyInfo escapeProcess = new DriverPropertyInfo("escapeProcess", info.getProperty("escapeProcess", "true"));
        escapeProcess.required = false;
        escapeProcess.description = this.res.getString("desciption.esscape.process");
        DriverPropertyInfo autoCommit = new DriverPropertyInfo("autoCommit", info.getProperty("autoCommit", "true"));
        autoCommit.required = false;
        autoCommit.description = this.res.getString("desciption.commit.auto");
        DriverPropertyInfo maxRows = new DriverPropertyInfo("maxRows", info.getProperty("maxRows", "0"));
        maxRows.required = false;
        maxRows.description = this.res.getString("desciption.rows.max");
        DriverPropertyInfo RowPrefetch = new DriverPropertyInfo("rowPrefetch", info.getProperty("rowPrefetch", "10"));
        RowPrefetch.required = false;
        RowPrefetch.description = this.res.getString("desciption.fetch.rowNum");
        DriverPropertyInfo LobMode = new DriverPropertyInfo("LobMode", info.getProperty("LobMode", "1"));
        LobMode.required = false;
        LobMode.description = this.res.getString("desciption.lob.mode");
        DriverPropertyInfo StmtPoolSize = new DriverPropertyInfo("StmtPoolSize", info.getProperty("StmtPoolSize", "0"));
        StmtPoolSize.required = false;
        StmtPoolSize.description = this.res.getString("desciption.stmtPool.size");
        DriverPropertyInfo ignoreCase = new DriverPropertyInfo("ignoreCase", info.getProperty("ignoreCase", "true"));
        ignoreCase.required = false;
        ignoreCase.description = this.res.getString("description.ignoreCase");
        DriverPropertyInfo comOra = new DriverPropertyInfo("comOra", info.getProperty("comOra", "false"));
        comOra.required = false;
        comOra.description = this.res.getString("description.comOra");
        DriverPropertyInfo infoLevel = new DriverPropertyInfo("infoLevel", info.getProperty("infoLevel", "1"));
        infoLevel.required = false;
        infoLevel.description = this.res.getString("description.infoLevel");
        DriverPropertyInfo alwayseAllowCommit = new DriverPropertyInfo("alwayseAllowCommit", info.getProperty("alwayseAllowCommit", "true"));
        alwayseAllowCommit.required = false;
        alwayseAllowCommit.description = "Allow commit even if autocommit is true";
        DriverPropertyInfo batchType = new DriverPropertyInfo("batchType", info.getProperty("batchType", "1"));
        batchType.required = false;
        batchType.description = this.res.getString("description.batchType");
        DriverPropertyInfo maxCachedPstmtSize = new DriverPropertyInfo("maxCachedPstmtSize", info.getProperty("maxCachedPstmtSize", "0"));
        maxCachedPstmtSize.required = false;
        maxCachedPstmtSize.description = "";
        DriverPropertyInfo maxCachedResultSet = new DriverPropertyInfo("maxCachedResultSet", info.getProperty("maxCachedResultSet", "0"));
        maxCachedResultSet.required = false;
        maxCachedResultSet.description = "";
        DriverPropertyInfo traceLevel = new DriverPropertyInfo("traceLevel", info.getProperty("traceLevel", "0"));
        traceLevel.required = false;
        traceLevel.description = this.res.getString("description.traceLevel");
        DriverPropertyInfo appName = new DriverPropertyInfo("appName", info.getProperty("appName", ""));
        appName.required = false;
        appName.description = this.res.getString("description.appName");
        DriverPropertyInfo sessionTimeout = new DriverPropertyInfo("sessionTimeout", info.getProperty("sessionTimeout", "0"));
        sessionTimeout.required = false;
        sessionTimeout.description = "0";
        DriverPropertyInfo isCompress = new DriverPropertyInfo("isCompress", info.getProperty("isCompress", "false"));
        isCompress.required = false;
        isCompress.description = "0";
        DriverPropertyInfo sslFilesPath = new DriverPropertyInfo("sslFilesPath", info.getProperty("sslFilesPath", ""));
        sslFilesPath.required = false;
        sslFilesPath.description = "";
        DriverPropertyInfo sslKeystorePass = new DriverPropertyInfo("sslKeystorePass", info.getProperty("sslKeystorePass", ""));
        sslKeystorePass.required = false;
        sslKeystorePass.description = "";
        DriverPropertyInfo resultSetType = new DriverPropertyInfo("resultSetType", info.getProperty("resultSetType", "1003"));
        resultSetType.required = false;
        resultSetType.description = "";
        DriverPropertyInfo kerberosLoginConfPath = new DriverPropertyInfo("kerberosLoginConfPath", info.getProperty("kerberosLoginConfPath"));
        kerberosLoginConfPath.required = false;
        kerberosLoginConfPath.description = "";
        DriverPropertyInfo mppLocal = new DriverPropertyInfo("mppLocal", info.getProperty("mppLocal"));
        kerberosLoginConfPath.required = false;
        kerberosLoginConfPath.description = "";
        DriverPropertyInfo rwSeparate = new DriverPropertyInfo("rwSeparate", info.getProperty("rwSeparate"));
        kerberosLoginConfPath.required = false;
        kerberosLoginConfPath.description = "";
        DriverPropertyInfo rwPercent = new DriverPropertyInfo("rwPercent", info.getProperty("rwPercent"));
        kerberosLoginConfPath.required = false;
        kerberosLoginConfPath.description = "";
        DriverPropertyInfo dbmdChkPrv = new DriverPropertyInfo("dbmdChkPrv", info.getProperty("dbmdChkPrv"));
        kerberosLoginConfPath.required = false;
        kerberosLoginConfPath.description = "Whether the privilege should be checked when getting database metadata information,false in default";
        DriverPropertyInfo uKeyName = new DriverPropertyInfo("uKeyName", info.getProperty("uKeyName"));
        uKeyName.required = false;
        uKeyName.description = "";
        DriverPropertyInfo uKeyPin = new DriverPropertyInfo("uKeyPin", info.getProperty("uKeyPin"));
        uKeyPin.required = false;
        uKeyPin.description = "";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp, continueBatchOnError, maxRows, autoCommit, RowPrefetch, LobMode, StmtPoolSize, ignoreCase, comOra, infoLevel, alwayseAllowCommit, batchType, maxCachedPstmtSize, maxCachedResultSet, traceLevel, appName, sessionTimeout, isCompress, sslFilesPath, sslKeystorePass, resultSetType, kerberosLoginConfPath, mppLocal, rwSeparate, rwPercent, dbmdChkPrv, uKeyName, uKeyPin};
        return dpi;
    }

    public int getMajorVersion() {
        int pointIndex = "7.6.0.197".indexOf(".");
        String ver = "7";
        if (pointIndex != -1) {
            ver = "7.6.0.197".substring(0, pointIndex);
        }
        return Integer.parseInt(ver);
    }

    public int getMinorVersion() {
        String fulVersion = "7.6.0.197";
        int pointIndex1 = fulVersion.indexOf(".");
        int pointIndex2 = -1;
        if (pointIndex1 != -1) {
            pointIndex2 = fulVersion.indexOf(".", pointIndex1 + 1);
        }
        String ver = "0";
        if (pointIndex1 != -1 && pointIndex2 != -1) {
            ver = fulVersion.substring(pointIndex1 + 1, pointIndex2);
        }
        return Integer.parseInt(ver);
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties parseURL(String url, Properties defaults) throws SQLException {
        StringTokenizer st;
        if (StringUtil.isEmpty(url = StringUtil.trimToEmpty(url))) return null;
        if (!url.toLowerCase().startsWith("jdbc:dm:") && !url.toLowerCase().startsWith("jdbc:oracle://")) {
            return null;
        }
        Properties urlProps = new Properties(defaults);
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                StringTokenizer vp = new StringTokenizer(queryParams.nextToken(), "=");
                String param = "";
                if (vp.hasMoreTokens()) {
                    param = vp.nextToken();
                }
                String value = "";
                if (vp.hasMoreTokens()) {
                    value = vp.nextToken();
                }
                if (value.length() <= 0 || param.length() <= 0) continue;
                urlProps.put(param.trim(), value.trim());
            }
        }
        if (!(st = new StringTokenizer(url, ":/[]", true)).hasMoreTokens()) {
            DBError.throwSQLException(20018);
            return null;
        }
        String protocol = st.nextToken();
        if (protocol == null) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!protocol.equalsIgnoreCase("jdbc")) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!st.hasMoreTokens()) {
            DBError.throwSQLException(20018);
            return null;
        }
        String colon = st.nextToken();
        if (colon == null) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!colon.equals(":")) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!st.hasMoreTokens()) {
            DBError.throwSQLException(20018);
            return null;
        }
        String subProto = st.nextToken();
        if (subProto == null) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!subProto.equalsIgnoreCase("dm")) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!st.hasMoreTokens()) {
            DBError.throwSQLException(20018);
            return null;
        }
        colon = st.nextToken();
        if (colon == null) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!colon.equals(":")) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!st.hasMoreTokens()) {
            DBError.throwSQLException(20018);
            return null;
        }
        String slash = st.nextToken();
        String slash2 = "";
        if (st.hasMoreTokens()) {
            slash2 = st.nextToken();
        }
        if (slash != null && slash2 != null) {
            if (!slash.equals("/") || !slash2.equals("/")) {
                DBError.throwSQLException(20018);
                return null;
            }
        } else {
            DBError.throwSQLException(20018);
            return null;
        }
        if (!st.hasMoreTokens()) return urlProps;
        String token = st.nextToken();
        if (token == null) {
            DBError.throwSQLException(20018);
            return null;
        }
        if (token.equals("[")) {
            int begin = url.indexOf("[");
            int end = url.indexOf("]");
            String ipv6 = url.substring(begin + 1, end);
            try {
                InetAddress inetAddress = InetAddress.getByName(ipv6);
                ipv6 = inetAddress.getHostAddress();
                urlProps.put("host", ipv6.trim());
                while (st.hasMoreTokens() && !(token = st.nextToken()).equals("]")) {
                }
                if (!st.hasMoreTokens()) return urlProps;
                token = st.nextToken();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (!token.equals(":") && !token.equals("/")) {
            urlProps.put("host", token.trim());
            if (!st.hasMoreTokens()) return urlProps;
            token = st.nextToken();
        }
        if (!token.equals(":")) return urlProps;
        if (!st.hasMoreTokens()) return urlProps;
        token = st.nextToken();
        urlProps.put("port", token.trim());
        if (!st.hasMoreTokens()) return urlProps;
        token = st.nextToken();
        return urlProps;
    }
}

