/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.AbstractProxy;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.stat.ConnectionStat;
import dm.jdbc.stat.ExecuteType;
import dm.jdbc.stat.SqlStat;
import dm.jdbc.util.StringUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbStatement
extends AbstractProxy<DmdbStatement_bs>
implements Statement {
    private DmdbStatement_bs rStmt = null;
    private DmdbResultSet curResultSet = null;
    private DmdbConnection curConnect = null;
    private static AtomicLong index = new AtomicLong(0L);
    private long constructNano;
    private long lastExecuteStartNano;
    private long lastExecuteTimeNano;
    private ExecuteType lastExecuteType;
    private boolean firstResultSet;
    private String lastExecuteSql;
    private SqlStat sqlStat;

    public DmdbStatement(DmdbStatement_bs Stmt, DmdbConnection curConn) throws SQLException {
        super(Stmt);
        this.rStmt = Stmt;
        this.curConnect = curConn;
        this.ID = index.incrementAndGet();
    }

    void setCurResultSet(DmdbResultSet rs) {
        if (this.curResultSet != null) {
            this.curResultSet = null;
        }
        this.curResultSet = rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.createChain().Statement_executeQuery(this, sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.createChain().Statement_executeUpdate(this, sql);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().Statement_close(this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.createChain().Statement_getMaxFieldSize(this);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.createChain().Statement_setMaxFieldSize(this, max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.createChain().Statement_getMaxRows(this);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.createChain().Statement_setMaxRows(this, max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.createChain().Statement_setEscapeProcessing(this, enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.createChain().Statement_getQueryTimeout(this);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.createChain().Statement_setQueryTimeout(this, seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.createChain().Statement_cancel(this);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().Statement_getWarnings(this);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().Statement_clearWarnings(this);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.createChain().Statement_setCursorName(this, name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.createChain().Statement_execute(this, sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createChain().Statement_getResultSet(this);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.createChain().Statement_getUpdateCount(this);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.createChain().Statement_getMoreResults(this);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.createChain().Statement_setFetchDirection(this, direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.createChain().Statement_getFetchDirection(this);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.createChain().Statement_setFetchSize(this, rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.createChain().Statement_getFetchSize(this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.createChain().Statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.createChain().Statement_getResultSetType(this);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.createChain().Statement_addBatch(this, sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.createChain().Statement_clearBatch(this);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.createChain().Statement_executeBatch(this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createChain().Statement_getConnection(this);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.createChain().Statement_getMoreResults(this, current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createChain().Statement_getGeneratedKeys(this);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createChain().Statement_executeUpdate(this, sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.createChain().Statement_executeUpdate(this, sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.createChain().Statement_executeUpdate(this, sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createChain().Statement_execute(this, sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.createChain().Statement_execute(this, sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.createChain().Statement_execute(this, sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.createChain().Statement_getResultSetHoldability(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().Statement_isClosed(this);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.createChain().Statement_setPoolable(this, poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.createChain().Statement_isPoolable(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.createChain().Statement_closeOnCompletion(this);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.createChain().Statement_isCloseOnCompletion(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public synchronized ResultSet do_executeQuery(String sql) throws SQLException {
        DmdbResultSet_bs rsb = (DmdbResultSet_bs)this.rStmt.executeQuery(sql);
        if (rsb == null) {
            return null;
        }
        DmdbResultSet rs = new DmdbResultSet(rsb, this);
        this.setCurResultSet(rs);
        return rs;
    }

    public synchronized int do_executeUpdate(String sql) throws SQLException {
        return this.rStmt.executeUpdate(sql);
    }

    public synchronized void do_close() throws SQLException {
        this.rStmt.close();
    }

    public int do_getMaxFieldSize() throws SQLException {
        return this.rStmt.getMaxFieldSize();
    }

    public synchronized void do_setMaxFieldSize(int max) throws SQLException {
        this.rStmt.setMaxFieldSize(max);
    }

    public int do_getMaxRows() throws SQLException {
        return this.rStmt.getMaxRows();
    }

    public synchronized void do_setMaxRows(int max) throws SQLException {
        this.rStmt.setMaxRows(max);
    }

    public void do_setEscapeProcessing(boolean enable) throws SQLException {
        this.rStmt.setEscapeProcessing(enable);
    }

    public int do_getQueryTimeout() throws SQLException {
        return this.rStmt.getQueryTimeout();
    }

    public synchronized void do_setQueryTimeout(int seconds) throws SQLException {
        this.rStmt.setQueryTimeout(seconds);
    }

    public synchronized void do_cancel() throws SQLException {
        this.rStmt.cancel();
    }

    public SQLWarning do_getWarnings() throws SQLException {
        return this.rStmt.getWarnings();
    }

    public void do_clearWarnings() throws SQLException {
        this.rStmt.clearWarnings();
    }

    public void do_setCursorName(String name) throws SQLException {
        this.rStmt.setCursorName(name);
    }

    public synchronized boolean do_execute(String sql) throws SQLException {
        return this.rStmt.execute(sql);
    }

    public synchronized ResultSet do_getResultSet() throws SQLException {
        DmdbResultSet_bs rs = (DmdbResultSet_bs)this.rStmt.getResultSet();
        if (rs == null) {
            return null;
        }
        this.curResultSet = new DmdbResultSet(rs, this);
        return this.curResultSet;
    }

    public synchronized int do_getUpdateCount() throws SQLException {
        return this.rStmt.getUpdateCount();
    }

    public boolean do_getMoreResults() throws SQLException {
        if (this.curResultSet != null) {
            this.curResultSet.close();
        }
        return this.rStmt.getMoreResults();
    }

    public synchronized void do_setFetchDirection(int direction) throws SQLException {
        this.rStmt.setFetchDirection(direction);
    }

    public int do_getFetchDirection() throws SQLException {
        return this.rStmt.getFetchDirection();
    }

    public synchronized void do_setFetchSize(int rows) throws SQLException {
        this.rStmt.setFetchSize(rows);
    }

    public int do_getFetchSize() throws SQLException {
        return this.rStmt.getFetchSize();
    }

    public int do_getResultSetConcurrency() throws SQLException {
        return this.rStmt.getResultSetConcurrency();
    }

    public int do_getResultSetType() throws SQLException {
        return this.rStmt.getResultSetType();
    }

    public void do_addBatch(String sql) throws SQLException {
        this.rStmt.addBatch(sql);
    }

    public void do_clearBatch() throws SQLException {
        this.rStmt.clearBatch();
    }

    public int[] do_executeBatch() throws SQLException {
        return this.rStmt.executeBatch();
    }

    public DmdbConnection do_getConnection() {
        return this.curConnect;
    }

    public synchronized boolean do_getMoreResults(int current) throws SQLException {
        if ((current == 1 || current == 3) && this.curResultSet != null) {
            this.curResultSet.close();
        }
        return this.rStmt.getMoreResults(current);
    }

    public ResultSet do_getGeneratedKeys() throws SQLException {
        DmdbResultSet_bs rsb = (DmdbResultSet_bs)this.rStmt.getGeneratedKeys();
        if (rsb == null) {
            return null;
        }
        return new DmdbResultSet(rsb, this);
    }

    public int do_executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.rStmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int do_executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.rStmt.executeUpdate(sql, columnIndexes);
    }

    public int do_executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.rStmt.executeUpdate(sql, columnNames);
    }

    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.rStmt.execute(sql, autoGeneratedKeys);
    }

    public boolean do_execute(String sql, int[] columnIndexes) throws SQLException {
        return this.rStmt.execute(sql, columnIndexes);
    }

    public boolean do_execute(String sql, String[] columnNames) throws SQLException {
        return this.rStmt.execute(sql, columnNames);
    }

    public int do_getResultSetHoldability() throws SQLException {
        return this.rStmt.getResultSetHoldability();
    }

    public boolean do_isClosed() throws SQLException {
        return this.rStmt.isClosed();
    }

    public void do_setPoolable(boolean poolable) throws SQLException {
        this.rStmt.setPoolable(poolable);
    }

    public boolean do_isPoolable() throws SQLException {
        return this.rStmt.isPoolable();
    }

    public synchronized void preCompile(String sql) throws SQLException {
        this.rStmt.preCompile(sql);
    }

    public synchronized void executeDirect() throws SQLException {
        this.rStmt.executeDirect();
    }

    public void do_closeOnCompletion() throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public boolean do_isCloseOnCompletion() throws SQLException {
        return false;
    }

    public long getExecuteId() {
        return this.rStmt.getExecuteId();
    }

    public long getRowId() {
        return this.rStmt.getRowId();
    }

    public void setSqlStat(SqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    public SqlStat getSqlStat() {
        return this.sqlStat;
    }

    public long getLastExecuteTimeNano() {
        return this.lastExecuteTimeNano;
    }

    public void setLastExecuteStartNano(long lastExecuteStartNano) {
        this.lastExecuteStartNano = lastExecuteStartNano;
    }

    public void setLastExecuteType(ExecuteType lastExecuteType) {
        this.lastExecuteType = lastExecuteType;
    }

    public long getLastExecuteStartNano() {
        return this.lastExecuteStartNano;
    }

    public void setLastExecuteTimeNano(long nanos) {
        this.lastExecuteTimeNano = nanos;
    }

    public ExecuteType getLastExecuteType() {
        return this.lastExecuteType;
    }

    public void setFirstResultSet(boolean firstResultSet) {
        this.firstResultSet = firstResultSet;
    }

    public boolean isFirstResultSet() {
        return this.firstResultSet;
    }

    public void setLastExecuteSql(String lastExecuteSql) {
        this.lastExecuteSql = lastExecuteSql;
    }

    public String getLastExecuteSql() {
        return this.lastExecuteSql;
    }

    public List<String> getBatchSqlList() {
        return this.rStmt.getBatchSqlList();
    }

    public String getBatchSql() {
        List<String> sqlList = this.getBatchSqlList();
        StringBuffer buf = new StringBuffer();
        for (String item : sqlList) {
            if (buf.length() > 0) {
                buf.append("\n;\n");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    public void afterExecute(long nanoSpan) {
        this.lastExecuteTimeNano = nanoSpan;
    }

    public void beforeExecute() {
        this.lastExecuteStartNano = System.nanoTime();
    }

    public void setConstructNano() {
        this.constructNano = System.nanoTime();
    }

    public long getConstructNano() {
        return this.constructNano;
    }

    public ConnectionStat getConnStat() {
        return this.curConnect.getConnStat();
    }

    public String getSql() {
        return this.rStmt.getOriginalSql();
    }

    public ResultSet[] getResultSets() {
        ArrayList<DmdbResultSet_bs> rsList = this.rStmt.getResultsList();
        return rsList != null ? rsList.toArray(new ResultSet[0]) : new ResultSet[]{};
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.createChain().Statement_getLargeUpdateCount(this);
    }

    public long do_getLargeUpdateCount() {
        long updateCount = -1L;
        if (!this.rStmt.dbInfo.getHasResultSet()) {
            updateCount = this.rStmt.dbInfo.getRowCount();
            updateCount = updateCount == 0L ? -1L : updateCount;
            this.rStmt.dbInfo.setRowCount(-1L);
        }
        return updateCount;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.createChain().Statement_setLargeMaxRows(this, max);
    }

    public void do_setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            DBError.throwSQLException(6036);
        }
        this.rStmt.maxRows = max;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.createChain().Statement_getLargeMaxRows(this);
    }

    public long do_getLargeMaxRows() throws SQLException {
        return this.rStmt.maxRows;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.createChain().Statement_executeLargeBatch(this);
    }

    public long[] do_executeLargeBatch() throws SQLException {
        long[] lArray;
        this.rStmt.resId = 0;
        this.rStmt.clearWarnings();
        if (this.rStmt.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        try {
            long[] updateCounts = new long[]{};
            if (this.rStmt.m_batchItems != null) {
                int nbrCommands = this.rStmt.m_batchItems.size();
                updateCounts = new long[nbrCommands];
                int i2 = 0;
                while (i2 < nbrCommands) {
                    updateCounts[i2] = -2L;
                    ++i2;
                }
                ArrayList<String> sqlExList = new ArrayList<String>();
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    try {
                        updateCounts[commandIndex] = this.executeLargeUpdate(this.rStmt.m_batchItems.get(commandIndex));
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3L;
                        if (this.rStmt.connection.isContinueBatchOnError()) {
                            sqlExList.add("sql[" + commandIndex + "]:" + ex.getErrorCode() + ", " + ex.getMessage());
                            SQLWarning warning = new SQLWarning("sql[" + commandIndex + "]:" + ex.getErrorCode() + ", " + ex.getMessage());
                            this.rStmt.connection.addWarnings(warning);
                        }
                        long[] newUpdateCounts = new long[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts, (Throwable)ex);
                    }
                    ++commandIndex;
                }
                if (sqlExList.size() > 0) {
                    StringBuilder errMsg = new StringBuilder();
                    for (String temp : sqlExList) {
                        errMsg.append(StringUtil.LINE_SEPARATOR).append(temp);
                    }
                    throw new BatchUpdateException(String.valueOf(DmSvcConf.res.getString("warn.bp_with_err")) + errMsg.toString(), null, 0, updateCounts, null);
                }
            }
            if (this.rStmt.connection.isCompatibleOracle()) {
                int i3 = 0;
                while (i3 < updateCounts.length) {
                    updateCounts[i3] = -2L;
                    ++i3;
                }
            }
            lArray = updateCounts;
        }
        catch (Throwable throwable) {
            this.rStmt.clearBatch();
            throw throwable;
        }
        this.rStmt.clearBatch();
        return lArray;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.createChain().Statement_executeLargeUpdate(this, sql);
    }

    public long do_executeLargeUpdate(String sql) throws SQLException {
        this.rStmt.executeInner(sql, 3);
        if (!this.rStmt.connection.isCompatibleOracle() && this.rStmt.dbInfo.getHasResultSet()) {
            DBError.throwSQLException(6009);
        }
        if (this.rStmt.dbInfo.getHasResultSet() && this.rStmt.dbInfo.getRowCount() == Long.MAX_VALUE) {
            return DmdbCSI.getRowCount(this.rStmt, this.rStmt.getCurrentRs().m_fromStandby);
        }
        if (this.rStmt.dbInfo.getRowCount() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.rStmt.dbInfo.getRowCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createChain().Statement_executeLargeUpdate(this, sql, autoGeneratedKeys);
    }

    public long do_executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.rStmt.setAutoGetKeysInner(autoGeneratedKeys);
        long updateCount = this.executeLargeUpdate(sql);
        this.rStmt.setAutoGenInfoAftExec();
        return updateCount;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.createChain().Statement_executeLargeUpdate(this, sql, columnIndexes);
    }

    public long do_executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.rStmt.setAutoGetKeys(true);
        } else {
            this.rStmt.setAutoGetKeys(false);
        }
        long ret = this.executeLargeUpdate(sql);
        this.rStmt.setAutoGenInfoAftExec();
        return ret;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.createChain().Statement_executeLargeUpdate(this, sql, columnNames);
    }

    public long do_executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            this.rStmt.setAutoGetKeys(true);
        } else {
            this.rStmt.setAutoGetKeys(false);
        }
        long ret = this.executeLargeUpdate(sql);
        this.rStmt.setAutoGenInfoAftExec();
        return ret;
    }
}

