/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;

public class LogRecord {
    public static final NullData NULL = new NullData();
    private Object source;
    private String method;
    private Object[] params;
    private Object returnValue;
    private Throwable e;
    private long usedTime;

    public LogRecord(Object source, String method, Object ... params) {
        this.source = source;
        this.method = method;
        this.params = params;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        str.append(this.formatTrace(this.formatSource(this.source)));
        if (this.usedTime > 0L) {
            str.append(this.formatUsedTime(this.usedTime));
        }
        return str.toString();
    }

    public String formatTrace(String source) {
        int i2;
        StringBuilder str = new StringBuilder(128);
        if (source != null) {
            str.append("{ " + source + " } ");
        }
        str.append(String.valueOf(this.method) + "(");
        int paramStartIndex = 0;
        if (this.params != null && this.params.length > paramStartIndex) {
            i2 = paramStartIndex;
            while (i2 < this.params.length) {
                if (i2 != paramStartIndex) {
                    str.append(", ");
                }
                if (this.params[i2] != null) {
                    str.append(this.params[i2].getClass().getSimpleName());
                } else {
                    str.append("null");
                }
                ++i2;
            }
        }
        str.append(")");
        if (this.returnValue != null) {
            str.append(": " + this.formatReturn(this.returnValue));
        }
        str.append(";  ");
        if (this.params != null && this.params.length > paramStartIndex) {
            str.append("[PARAMS]: ");
            i2 = paramStartIndex;
            while (i2 < this.params.length) {
                if (i2 != 0) {
                    str.append(", ");
                }
                if (this.params[i2] instanceof String) {
                    str.append("\"").append(this.params[i2]).append("\"");
                } else {
                    str.append(this.params[i2]);
                }
                ++i2;
            }
            str.append("; ");
        }
        return str.toString();
    }

    private String formatSource(Object source) {
        if (source != null) {
            StringBuffer str = new StringBuffer(128);
            if (source instanceof DmdbConnection) {
                str.append(this.formatConn((DmdbConnection)source));
            } else if (source instanceof DmdbStatement) {
                str.append(this.formatConn(((DmdbStatement)source).do_getConnection())).append(", ");
                str.append(this.formatStmt((DmdbStatement)source));
            } else if (source instanceof DmdbResultSet) {
                str.append(this.formatConn(((DmdbResultSet)source).do_getStatement() == null ? null : ((DmdbResultSet)source).do_getStatement().do_getConnection())).append(", ");
                str.append(this.formatStmt(((DmdbResultSet)source).do_getStatement())).append(", ");
                str.append(this.formatRs((DmdbResultSet)source));
            } else if (source instanceof DmdbDatabaseMetaData) {
                str.append(this.formatConn(((DmdbDatabaseMetaData)source).do_getConnection())).append(", ");
                str.append("dbmd-" + ((DmdbDatabaseMetaData)source).getID());
            } else if (source instanceof DmdbResultSetMetaData) {
                str.append(this.formatRs(((DmdbResultSetMetaData)source).do_getResultSet())).append(", ");
                str.append("rsmd-" + ((DmdbResultSetMetaData)source).getID());
            } else if (source instanceof DmdbParameterMetaData) {
                str.append(this.formatStmt(((DmdbParameterMetaData)source).do_getPreparedStatement())).append(", ");
                str.append("pmd-" + ((DmdbParameterMetaData)source).getID());
            } else {
                str.append(source);
            }
            return str.toString();
        }
        return "";
    }

    public String formatReturn(Object returnObject) {
        String str = "";
        str = returnObject instanceof DmdbConnection ? this.formatConn((DmdbConnection)returnObject) : (returnObject instanceof DmdbStatement ? this.formatStmt((DmdbStatement)returnObject) : (returnObject instanceof DmdbResultSet ? this.formatRs((DmdbResultSet)returnObject) : (returnObject instanceof DmdbDatabaseMetaData ? "dbmd-" + ((DmdbDatabaseMetaData)returnObject).getID() : (returnObject instanceof DmdbResultSetMetaData ? "rsmd-" + ((DmdbResultSetMetaData)returnObject).getID() : (returnObject instanceof DmdbParameterMetaData ? "pmd-" + ((DmdbParameterMetaData)returnObject).getID() : (returnObject instanceof String ? "\"" + returnObject.toString() + "\"" : (returnObject instanceof NullData ? "null" : returnObject.toString())))))));
        return str;
    }

    private String formatConn(DmdbConnection connection) {
        if (connection != null) {
            return "conn-" + connection.getID();
        }
        return "conn-null";
    }

    private String formatStmt(DmdbStatement statement) {
        if (statement != null) {
            if (statement instanceof DmdbCallableStatement) {
                return "cstmt-" + statement.getID();
            }
            if (statement instanceof DmdbPreparedStatement) {
                return "pstmt-" + statement.getID();
            }
            return "stmt-" + statement.getID();
        }
        return "stmt-null";
    }

    private String formatRs(DmdbResultSet resultSet) {
        if (resultSet != null) {
            return "rs-" + resultSet.getID();
        }
        return "rs-null";
    }

    private String formatUsedTime(long nano) {
        return "[USED TIME]: " + (double)nano / 1000000.0 + "ms;";
    }

    public void setThrowable(Throwable e2) {
        this.e = e2;
    }

    public Throwable getThrowable() {
        return this.e;
    }

    public void setReturnValue(Object retValue) {
        this.returnValue = retValue == null ? NULL : retValue;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setUsedTime(long usedTime) {
        this.usedTime = usedTime;
    }

    public long getUsedTime() {
        return this.usedTime;
    }

    static class NullData {
        NullData() {
        }
    }
}

