/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jzlib;

import dm.jdbc.jzlib.InfBlocks;
import dm.jdbc.jzlib.ZStream;

final class Inflate {
    private static final int MAX_WBITS = 15;
    private static final int PRESET_DICT = 32;
    static final int Z_NO_FLUSH = 0;
    static final int Z_PARTIAL_FLUSH = 1;
    static final int Z_SYNC_FLUSH = 2;
    static final int Z_FULL_FLUSH = 3;
    static final int Z_FINISH = 4;
    private static final int Z_DEFLATED = 8;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private static final int METHOD = 0;
    private static final int FLAG = 1;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    int mode;
    int method;
    long[] was = new long[1];
    long need;
    int marker;
    int nowrap;
    int wbits;
    InfBlocks blocks;
    private static byte[] mark;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -1;
        byArray[3] = -1;
        mark = byArray;
    }

    Inflate() {
    }

    int inflateReset(ZStream z2) {
        if (z2 == null || z2.istate == null) {
            return -2;
        }
        z2.total_out = 0L;
        z2.total_in = 0L;
        z2.msg = null;
        z2.istate.mode = z2.istate.nowrap != 0 ? 7 : 0;
        z2.istate.blocks.reset(z2, null);
        return 0;
    }

    int inflateEnd(ZStream z2) {
        if (this.blocks != null) {
            this.blocks.free(z2);
        }
        this.blocks = null;
        return 0;
    }

    int inflateInit(ZStream z2, int w2) {
        z2.msg = null;
        this.blocks = null;
        this.nowrap = 0;
        if (w2 < 0) {
            w2 = -w2;
            this.nowrap = 1;
        }
        if (w2 < 8 || w2 > 15) {
            this.inflateEnd(z2);
            return -2;
        }
        this.wbits = w2;
        z2.istate.blocks = new InfBlocks(z2, z2.istate.nowrap != 0 ? null : this, 1 << w2);
        this.inflateReset(z2);
        return 0;
    }

    int inflate(ZStream z2, int f2) {
        if (z2 == null || z2.istate == null || z2.next_in == null) {
            return -2;
        }
        f2 = f2 == 4 ? -5 : 0;
        int r2 = -5;
        block16: while (true) {
            switch (z2.istate.mode) {
                case 0: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if (((z2.istate.method = z2.next_in[z2.next_in_index++]) & 0xF) != 8) {
                        z2.istate.mode = 13;
                        z2.msg = "unknown compression method";
                        z2.istate.marker = 5;
                        continue block16;
                    }
                    if ((z2.istate.method >> 4) + 8 > z2.istate.wbits) {
                        z2.istate.mode = 13;
                        z2.msg = "invalid window size";
                        z2.istate.marker = 5;
                        continue block16;
                    }
                    z2.istate.mode = 1;
                }
                case 1: {
                    int b2;
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    if (((z2.istate.method << 8) + (b2 = z2.next_in[z2.next_in_index++] & 0xFF)) % 31 != 0) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect header check";
                        z2.istate.marker = 5;
                        continue block16;
                    }
                    if ((b2 & 0x20) == 0) {
                        z2.istate.mode = 7;
                        continue block16;
                    }
                    z2.istate.mode = 2;
                }
                case 2: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need = (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z2.istate.mode = 3;
                }
                case 3: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z2.istate.mode = 4;
                }
                case 4: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z2.istate.mode = 5;
                }
                case 5: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)z2.next_in[z2.next_in_index++] & 0xFFL;
                    z2.adler = z2.istate.need;
                    z2.istate.mode = 6;
                    return 2;
                }
                case 6: {
                    z2.istate.mode = 13;
                    z2.msg = "need dictionary";
                    z2.istate.marker = 0;
                    return -2;
                }
                case 7: {
                    r2 = z2.istate.blocks.proc(z2, r2);
                    if (r2 == -3) {
                        z2.istate.mode = 13;
                        z2.istate.marker = 0;
                        continue block16;
                    }
                    if (r2 == 0) {
                        r2 = f2;
                    }
                    if (r2 != 1) {
                        return r2;
                    }
                    r2 = f2;
                    z2.istate.blocks.reset(z2, z2.istate.was);
                    if (z2.istate.nowrap != 0) {
                        z2.istate.mode = 12;
                        continue block16;
                    }
                    z2.istate.mode = 8;
                }
                case 8: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need = (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    z2.istate.mode = 9;
                }
                case 9: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    z2.istate.mode = 10;
                }
                case 10: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)((z2.next_in[z2.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    z2.istate.mode = 11;
                }
                case 11: {
                    if (z2.avail_in == 0) {
                        return r2;
                    }
                    r2 = f2;
                    --z2.avail_in;
                    ++z2.total_in;
                    z2.istate.need += (long)z2.next_in[z2.next_in_index++] & 0xFFL;
                    if ((int)z2.istate.was[0] != (int)z2.istate.need) {
                        z2.istate.mode = 13;
                        z2.msg = "incorrect data check";
                        z2.istate.marker = 5;
                        continue block16;
                    }
                    z2.istate.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
            }
            break;
        }
        return -2;
    }

    int inflateSetDictionary(ZStream z2, byte[] dictionary, int dictLength) {
        int index = 0;
        int length = dictLength;
        if (z2 == null || z2.istate == null || z2.istate.mode != 6) {
            return -2;
        }
        if (z2._adler.adler32(1L, dictionary, 0, dictLength) != z2.adler) {
            return -3;
        }
        z2.adler = z2._adler.adler32(0L, null, 0, 0);
        if (length >= 1 << z2.istate.wbits) {
            length = (1 << z2.istate.wbits) - 1;
            index = dictLength - length;
        }
        z2.istate.blocks.set_dictionary(dictionary, index, length);
        z2.istate.mode = 7;
        return 0;
    }

    int inflateSync(ZStream z2) {
        int n2;
        if (z2 == null || z2.istate == null) {
            return -2;
        }
        if (z2.istate.mode != 13) {
            z2.istate.mode = 13;
            z2.istate.marker = 0;
        }
        if ((n2 = z2.avail_in) == 0) {
            return -5;
        }
        int p2 = z2.next_in_index;
        int m3 = z2.istate.marker;
        while (n2 != 0 && m3 < 4) {
            m3 = z2.next_in[p2] == mark[m3] ? ++m3 : (z2.next_in[p2] != 0 ? 0 : 4 - m3);
            ++p2;
            --n2;
        }
        z2.total_in += (long)(p2 - z2.next_in_index);
        z2.next_in_index = p2;
        z2.avail_in = n2;
        z2.istate.marker = m3;
        if (m3 != 4) {
            return -3;
        }
        long r2 = z2.total_in;
        long w2 = z2.total_out;
        this.inflateReset(z2);
        z2.total_in = r2;
        z2.total_out = w2;
        z2.istate.mode = 7;
        return 0;
    }

    int inflateSyncPoint(ZStream z2) {
        if (z2 == null || z2.istate == null || z2.istate.blocks == null) {
            return -2;
        }
        return z2.istate.blocks.sync_point();
    }
}

