/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogWriter;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger
implements ILogger {
    public Logger(String name) {
    }

    public boolean isDebugEnabled() {
        return DmSvcConf.logLevel >= 5;
    }

    public boolean isErrorEnabled() {
        return DmSvcConf.logLevel >= 1;
    }

    public boolean isInfoEnabled() {
        return DmSvcConf.logLevel >= 4;
    }

    public boolean isWarnEnabled() {
        return DmSvcConf.logLevel >= 2;
    }

    public boolean isSqlEnabled() {
        return DmSvcConf.logLevel >= 3;
    }

    public void debug(Object message) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object message, Throwable t2) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + message.toString() + StringUtil.LINE_SEPARATOR + this.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object message) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object source, String method, String info) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object source, String method, Object ... params) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object source, String method, Object ... params) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(source, method, params));
            }
        }
        catch (Exception exception) {}
    }

    public void debug(Object source, String method, String info) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(source, method, info));
            }
        }
        catch (Exception exception) {}
    }

    public void info(Object message, Throwable t2) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + message.toString() + StringUtil.LINE_SEPARATOR + this.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    public void sql(Object message) {
        try {
            if (this.isSqlEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void warn(Object message) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void warn(Object message, Throwable t2) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + message.toString() + StringUtil.LINE_SEPARATOR + this.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    public void error(Object message) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(this.formatHead("ERROR")) + message.toString());
            }
        }
        catch (Exception exception) {}
    }

    public void error(Object message, Throwable t2) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(this.formatHead("ERROR")) + message.toString() + StringUtil.LINE_SEPARATOR + this.getStackTrace(t2));
            }
        }
        catch (Exception exception) {}
    }

    private String formatHead(String head) {
        return "[" + head + " - " + StringUtil.formatTime() + "] tid:" + Thread.currentThread().getId();
    }

    private void println(String msg) {
        LogWriter.getInstance().writeLine(StringUtil.trimToEmpty(msg));
    }

    private String getStackTrace(Throwable t2) {
        if (t2 != null) {
            StringWriter out = new StringWriter(256);
            t2.printStackTrace(new PrintWriter(out));
            return String.valueOf(out.toString()) + StringUtil.LINE_SEPARATOR;
        }
        return "";
    }

    private static String formatSource(Object source) {
        return String.valueOf(source.getClass().getSimpleName()) + "@" + Integer.toHexString(source.hashCode());
    }

    private static String formatTrace(Object source, String method, String info) {
        StringBuilder str = new StringBuilder();
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(method).append("();  ");
        str.append(info);
        return str.toString();
    }

    private static String formatTrace(Object source, String method, Object ... params) {
        int i2;
        StringBuilder str = new StringBuilder(128);
        if (source != null) {
            str.append("{ " + Logger.formatSource(source) + " } ");
        }
        str.append(String.valueOf(method) + "(");
        int paramStartIndex = 0;
        if (params != null && params.length > paramStartIndex) {
            i2 = paramStartIndex;
            while (i2 < params.length) {
                if (i2 != paramStartIndex) {
                    str.append(", ");
                }
                str.append(params[i2].getClass().getSimpleName());
                ++i2;
            }
        }
        str.append(");  ");
        if (params != null && params.length > paramStartIndex) {
            str.append("[PARAMS]: ");
            i2 = paramStartIndex;
            while (i2 < params.length) {
                if (i2 != 0) {
                    str.append(", ");
                }
                if (params[i2] instanceof String) {
                    str.append("\"").append(params[i2]).append("\"");
                } else {
                    str.append(params[i2]);
                }
                ++i2;
            }
            str.append("; ");
        }
        return str.toString();
    }
}

