/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.parser;

import dm.jdbc.parser.Lexer;
import java.io.IOException;
import java.io.StringReader;

public class LVal
implements Cloneable {
    public static final int MAX_DEC_LEN = 38;
    public String value;
    public Type type;
    public int position;

    public LVal() {
        this.reset();
    }

    public LVal(String value, Type type) {
        this.value = value;
        this.type = type;
    }

    public void reset() {
        this.value = "";
        this.type = Type.NORMAL;
    }

    public String toString() {
        return (Object)((Object)this.type) + ": " + this.value;
    }

    protected LVal clone() {
        try {
            return (LVal)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public static void main(String[] args) throws IOException {
        String sql = "select {'1''2'} /***/ from \"dual\";";
        Lexer lexer = new Lexer(new StringReader(sql), true);
        LVal lval = null;
        while ((lval = lexer.yylex()) != null) {
            System.out.println(lval);
        }
        lexer.yyclose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        INT,
        DOUBLE,
        DECIMAL,
        STRING,
        HEX_INT,
        WHITESPACE_OR_COMMENT,
        NULL;

    }
}

