/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmDriver_bs;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.pool.DmdbDataSource;
import dm.jdbc.rowset.DmdbCachedRowSet_bs;
import dm.jdbc.rowset.DmdbRow;
import dm.jdbc.rowset.DmdbRowSetMetaData;
import dm.jdbc.rowset.DmdbSerialBlob;
import dm.jdbc.rowset.DmdbSerialClob;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.spi.SyncProviderException;

public class DmdbCachedRowSet
extends DmdbCachedRowSet_bs
implements CachedRowSet,
RowSetInternal {
    private DmdbConnection m_conn = null;
    private DmdbResultSet m_resultSet = null;
    private static transient DmDriver_bs m_driver = null;

    @Override
    DmdbConnection_bs getConnectionInner() throws SQLException {
        DmdbConnection conn = this.m_conn;
        if (conn != null && !conn.isClosed()) {
            return conn.getRealConn();
        }
        String dataSourceName = this.getDataSourceName();
        if (dataSourceName != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DmdbDataSource datasource = (DmdbDataSource)initialcontext.lookup(dataSourceName);
                conn = (DmdbConnection)datasource.getConnection();
            }
            catch (NamingException namingexception) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingexception.getMessage());
            }
        } else {
            if (m_driver == null) {
                m_driver = new DmDriver_bs();
            }
            String url = this.getUrl();
            String usr = this.getUsername();
            String psw = this.getPassword();
            Properties props = DmDriver_bs.parseURL(url, null);
            Properties properties = props = props == null ? new Properties() : props;
            if (!props.containsKey("user")) {
                props.put("user", usr);
            }
            if (!props.containsKey("password")) {
                props.put("password", psw);
            }
            conn = new DmdbConnection((DmdbConnection_bs)m_driver.connect(url, props));
        }
        conn.setTransactionIsolation(this.getTransactionIsolation());
        conn.setTypeMap(this.getTypeMap());
        this.m_closed = false;
        this.m_conn = conn;
        return conn.getRealConn();
    }

    private void checkConnSpecified(Connection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw new SQLException(DmSvcConf.res.getString("error.cachedROwSetSpecConnInvalid"));
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setObjectInner((Object)parameterName, null, sqlType, false);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setObjectInner((Object)parameterName, null, sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setByte(String parameterName, byte x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setShort(String parameterName, short x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setInt(String parameterName, int x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setLong(String parameterName, long x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setFloat(String parameterName, float x2) throws SQLException {
        this.setObjectInner(parameterName, Float.valueOf(x2));
    }

    @Override
    public void setDouble(String parameterName, double x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setString(String parameterName, String x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, length, false);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, length, false);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)reader, length, false);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setObjectInner(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setObjectInner(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.setObjectInner((Object)parameterIndex, x2, targetSqlType, true);
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.setObjectInner(parameterIndex, x2);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.setObjectInner((Object)parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.setObjectInner((Object)parameterName, x2, targetSqlType, true);
    }

    @Override
    public void setObject(String parameterName, Object x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setObjectInner(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setObjectInner(parameterName, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setObjectInner((Object)parameterIndex, (Object)reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setObjectInner(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setObjectInner(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setTime(String parameterName, Time x2) throws SQLException {
        this.setObjectInner(parameterName, x2);
    }

    @Override
    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.setObjectInner((Object)parameterName, (Object)x2, cal);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, -8);
        } else {
            long val = ((DmdbRowId)x2).getValue();
            this.setLong(parameterIndex, val);
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterName, -8);
        } else {
            long val = ((DmdbRowId)x2).getValue();
            this.setLong(parameterName, val);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        long val = this.getLong(columnIndex);
        String tabName = this.m_rsmd.getTableName(columnIndex);
        String schName = this.m_rsmd.getSchemaName(columnIndex);
        return new DmdbRowId(val, schName, tabName);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_resultSet.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.updateAsciiStream(columnIndex, x2);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, x2);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.updateAsciiStream(columnLabel, x2);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.updateBinaryStream(columnLabel, x2);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.updateObjectInner(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x2);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x2);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateObjectInner(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateObjectInner(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateObjectInner(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj);
        }
        if (obj instanceof DmdbSerialBlob) {
            DmdbSerialBlob blob = (DmdbSerialBlob)obj;
            byte[] bs = blob.getBytes(0L, (int)blob.length());
            return new String(bs);
        }
        if (obj instanceof DmdbSerialClob) {
            DmdbSerialClob clob = (DmdbSerialClob)obj;
            return clob.getSubString(0L, (int)clob.length());
        }
        return obj.toString();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes()[0];
        }
        if (obj instanceof DmdbSerialBlob) {
            DmdbSerialBlob blob = (DmdbSerialBlob)obj;
            byte[] bs = blob.getBytes(0L, (int)blob.length());
            return bs[0];
        }
        if (obj instanceof DmdbSerialClob) {
            DmdbSerialClob clob = (DmdbSerialClob)obj;
            return clob.getSubString(0L, (int)clob.length()).getBytes()[0];
        }
        throw new SQLException(DmSvcConf.res.getString("error.dataConvertionError"));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object obj = this.getObjectInner(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Number) {
            return ((Number)obj).toString().getBytes();
        }
        if (obj instanceof DmdbSerialBlob) {
            DmdbSerialBlob blob = (DmdbSerialBlob)obj;
            byte[] bs = blob.getBytes(0L, (int)blob.length());
            return bs;
        }
        if (obj instanceof DmdbSerialClob) {
            DmdbSerialClob clob = (DmdbSerialClob)obj;
            return clob.getSubString(0L, (int)clob.length()).getBytes();
        }
        throw new SQLException(DmSvcConf.res.getString("error.dataConvertionError"));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DmdbResultSetMetaData(this.m_rsmd, this.m_resultSet);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.m_resultSet != null) {
            return this.m_resultSet.getStatement();
        }
        DBError.throwSQLException(DmSvcConf.res.getString("error.cachedRowSetRsNotOpen"));
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.getConnectionInner();
        return this.m_conn;
    }

    @Override
    public void populate(ResultSet data) throws SQLException {
        this.m_resultSet = (DmdbResultSet)data;
        super.populate(this.m_resultSet.getRealRs());
    }

    @Override
    public void setMetaData(RowSetMetaData md) throws SQLException {
        if (md instanceof DmdbRowSetMetaData) {
            this.setMetaData(((DmdbResultSetMetaData)((Object)md)).getRealRsmd());
        }
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        DmdbCachedRowSet cachedrowset = new DmdbCachedRowSet();
        cachedrowset.m_rsmd = this.m_rsmd;
        cachedrowset.m_rowCount = this.m_rowCount;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_currentRow = 0;
        cachedrowset.setType(1004);
        cachedrowset.setConcurrency(1008);
        cachedrowset.setReader(null);
        cachedrowset.setWriter(null);
        DmdbRow row = null;
        int i2 = 0;
        while (i2 < this.m_rows.size()) {
            row = new DmdbRow(this.m_columnCount, ((DmdbRow)this.m_rows.elementAt(i2)).getOriginalRow());
            cachedrowset.m_rows.add(row);
            ++i2;
        }
        return cachedrowset;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        DmdbCachedRowSet cachedrowset = new DmdbCachedRowSet();
        cachedrowset.m_rsmd = this.m_rsmd;
        cachedrowset.m_rowCount = 1;
        cachedrowset.m_columnCount = this.m_columnCount;
        cachedrowset.m_currentRow = 0;
        cachedrowset.setReader(null);
        cachedrowset.setWriter(null);
        DmdbRow row = new DmdbRow(this.m_rsmd.getColumnCount(), this.getCurrentRow().getOriginalRow());
        cachedrowset.m_rows.add(row);
        return cachedrowset;
    }

    @Override
    public RowSet createShared() throws SQLException {
        DmdbCachedRowSet rowset = new DmdbCachedRowSet();
        this.rowsetShared(rowset);
        return rowset;
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        DmdbCachedRowSet rowset = new DmdbCachedRowSet();
        this.rowsetCopy(rowset);
        return rowset;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        DmdbCachedRowSet rowset = (DmdbCachedRowSet)this.createCopy();
        rowset.m_rows = null;
        rowset.m_currentRow = 0;
        rowset.m_rowCount = 0;
        rowset.m_currentPage = 0;
        return rowset;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        DmdbCachedRowSet rowset = (DmdbCachedRowSet)this.createCopy();
        rowset.m_listeners = new Vector();
        rowset.unsetMatchColumn(rowset.getMatchColumnIndexes());
        rowset.unsetMatchColumn(rowset.getMatchColumnNames());
        return rowset;
    }

    @Override
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        if (numRows < 0 || numRows > this.m_rowCount) {
            throw new SQLException(DmSvcConf.res.getString("error.cachedRowSetRowParamInvalid"));
        }
        if (this.m_rowCount % numRows == 0) {
            event = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public void populate(ResultSet rs, int startRow) throws SQLException {
        this.m_resultSet = (DmdbResultSet)rs;
        super.populate(this.m_resultSet.getRealRs(), startRow);
    }

    @Override
    public void execute(Connection conn) throws SQLException {
        this.checkConnSpecified(conn);
        this.m_conn = (DmdbConnection)conn;
        super.execute(this.m_conn.getRealConn());
        this.m_resultSet = this.m_resultSet_bs == null ? null : new DmdbResultSet(this.m_resultSet_bs);
    }

    @Override
    public void acceptChanges(Connection conn) throws SyncProviderException {
        try {
            this.checkConnSpecified(conn);
        }
        catch (SQLException ex) {
            throw new SyncProviderException(ex.getMessage());
        }
        this.m_conn = (DmdbConnection)conn;
        super.acceptChanges(this.m_conn.getRealConn());
    }

    @Override
    public void execute() throws SQLException {
        this.getConnection();
        super.execute();
        this.m_resultSet = this.m_resultSet_bs == null ? null : new DmdbResultSet(this.m_resultSet_bs);
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            this.getConnection();
        }
        catch (SQLException ex) {
            throw new SyncProviderException(ex.getMessage());
        }
        super.acceptChanges();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }
}

