/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

public class IPAddressUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] textToNumericFormatV4(String paramString) {
        if (paramString.length() == 0) {
            return null;
        }
        byte[] arrayOfByte = new byte[4];
        String[] arrayOfString = paramString.split("\\.", -1);
        try {
            switch (arrayOfString.length) {
                case 1: {
                    long l2 = Long.parseLong(arrayOfString[0]);
                    if (l2 < 0L) return null;
                    if (l2 > 0xFFFFFFFFL) {
                        return null;
                    }
                    arrayOfByte[0] = (byte)(l2 >> 24 & 0xFFL);
                    arrayOfByte[1] = (byte)((l2 & 0xFFFFFFL) >> 16 & 0xFFL);
                    arrayOfByte[2] = (byte)((l2 & 0xFFFFL) >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l2 & 0xFFL);
                    return arrayOfByte;
                }
                case 2: {
                    long l3 = Integer.parseInt(arrayOfString[0]);
                    if (l3 < 0L) return null;
                    if (l3 > 255L) {
                        return null;
                    }
                    arrayOfByte[0] = (byte)(l3 & 0xFFL);
                    l3 = Integer.parseInt(arrayOfString[1]);
                    if (l3 < 0L) return null;
                    if (l3 > 0xFFFFFFL) {
                        return null;
                    }
                    arrayOfByte[1] = (byte)(l3 >> 16 & 0xFFL);
                    arrayOfByte[2] = (byte)((l3 & 0xFFFFL) >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l3 & 0xFFL);
                    return arrayOfByte;
                }
                case 3: {
                    long l4;
                    int i2 = 0;
                    while (true) {
                        if (i2 >= 2) {
                            l4 = Integer.parseInt(arrayOfString[2]);
                            if (l4 < 0L) return null;
                            if (l4 <= 65535L) break;
                            return null;
                        }
                        l4 = Integer.parseInt(arrayOfString[i2]);
                        if (l4 < 0L) return null;
                        if (l4 > 255L) {
                            return null;
                        }
                        arrayOfByte[i2] = (byte)(l4 & 0xFFL);
                        ++i2;
                    }
                    arrayOfByte[2] = (byte)(l4 >> 8 & 0xFFL);
                    arrayOfByte[3] = (byte)(l4 & 0xFFL);
                    return arrayOfByte;
                }
                case 4: {
                    int i3 = 0;
                    while (i3 < 4) {
                        long l5 = Integer.parseInt(arrayOfString[i3]);
                        if (l5 < 0L) return null;
                        if (l5 > 255L) {
                            return null;
                        }
                        arrayOfByte[i3] = (byte)(l5 & 0xFFL);
                        ++i3;
                    }
                    return arrayOfByte;
                }
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static byte[] textToNumericFormatV6(String paramString) {
        int i4;
        if (paramString.length() < 2) {
            return null;
        }
        char[] arrayOfChar = paramString.toCharArray();
        byte[] arrayOfByte1 = new byte[16];
        int m3 = arrayOfChar.length;
        int n2 = paramString.indexOf("%");
        if (n2 == m3 - 1) {
            return null;
        }
        if (n2 != -1) {
            m3 = n2;
        }
        int i2 = -1;
        int i1 = 0;
        int i22 = 0;
        if (arrayOfChar[i1] == ':' && arrayOfChar[++i1] != ':') {
            return null;
        }
        int i3 = i1;
        boolean j2 = false;
        int k2 = 0;
        while (i1 < m3) {
            char c2;
            if ((i4 = Character.digit(c2 = arrayOfChar[i1++], 16)) != -1) {
                k2 <<= 4;
                if ((k2 |= i4) > 65535) {
                    return null;
                }
                j2 = true;
                continue;
            }
            if (c2 == ':') {
                i3 = i1;
                if (!j2) {
                    if (i2 != -1) {
                        return null;
                    }
                    i2 = i22;
                    continue;
                }
                if (i1 == m3) {
                    return null;
                }
                if (i22 + 2 > 16) {
                    return null;
                }
                arrayOfByte1[i22++] = (byte)(k2 >> 8 & 0xFF);
                arrayOfByte1[i22++] = (byte)(k2 & 0xFF);
                j2 = false;
                k2 = 0;
                continue;
            }
            if (c2 == '.' && i22 + 4 <= 16) {
                String str = paramString.substring(i3, m3);
                int i5 = 0;
                int i6 = 0;
                while ((i6 = str.indexOf(46, i6)) != -1) {
                    ++i5;
                    ++i6;
                }
                if (i5 != 3) {
                    return null;
                }
                byte[] arrayOfByte3 = IPAddressUtil.textToNumericFormatV4(str);
                if (arrayOfByte3 == null) {
                    return null;
                }
                int i7 = 0;
                while (i7 < 4) {
                    arrayOfByte1[i22++] = arrayOfByte3[i7];
                    ++i7;
                }
                j2 = false;
                continue;
            }
            return null;
        }
        if (j2) {
            if (i22 + 2 > 16) {
                return null;
            }
            arrayOfByte1[i22++] = (byte)(k2 >> 8 & 0xFF);
            arrayOfByte1[i22++] = (byte)(k2 & 0xFF);
        }
        if (i2 != -1) {
            i4 = i22 - i2;
            if (i22 == 16) {
                return null;
            }
            i1 = 1;
            while (i1 <= i4) {
                arrayOfByte1[16 - i1] = arrayOfByte1[i2 + i4 - i1];
                arrayOfByte1[i2 + i4 - i1] = 0;
                ++i1;
            }
            i22 = 16;
        }
        if (i22 != 16) {
            return null;
        }
        byte[] arrayOfByte2 = IPAddressUtil.convertFromIPv4MappedAddress(arrayOfByte1);
        if (arrayOfByte2 != null) {
            return arrayOfByte2;
        }
        return arrayOfByte1;
    }

    public static boolean isIPv4LiteralAddress(String paramString) {
        return IPAddressUtil.textToNumericFormatV4(paramString) != null;
    }

    public static boolean isIPv6LiteralAddress(String paramString) {
        return IPAddressUtil.textToNumericFormatV6(paramString) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] paramArrayOfByte) {
        if (IPAddressUtil.isIPv4MappedAddress(paramArrayOfByte)) {
            byte[] arrayOfByte = new byte[4];
            System.arraycopy(paramArrayOfByte, 12, arrayOfByte, 0, 4);
            return arrayOfByte;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] paramArrayOfByte) {
        if (paramArrayOfByte.length < 16) {
            return false;
        }
        return paramArrayOfByte[0] == 0 && paramArrayOfByte[1] == 0 && paramArrayOfByte[2] == 0 && paramArrayOfByte[3] == 0 && paramArrayOfByte[4] == 0 && paramArrayOfByte[5] == 0 && paramArrayOfByte[6] == 0 && paramArrayOfByte[7] == 0 && paramArrayOfByte[8] == 0 && paramArrayOfByte[9] == 0 && paramArrayOfByte[10] == -1 && paramArrayOfByte[11] == -1;
    }
}

