/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectUtil {
    private static final Class<?>[] EMPTY_PARAMETER_TYPES = new Class[0];
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static HashMap<Class<?>, PropertyDescriptor[]> descriptorsCache = new HashMap();

    public static boolean isInterface(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isInterface(modifiers);
    }

    public static boolean isAbstract(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers);
    }

    public static boolean isAbstractOrInterface(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers);
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet interfaceList = new LinkedHashSet();
        Class<?> c2 = clazz;
        do {
            Class<?>[] interfaceArray = c2.getInterfaces();
            interfaceList.addAll(Arrays.asList(interfaceArray));
        } while ((c2 = c2.getSuperclass()) != null);
        return interfaceList.toArray(new Class[interfaceList.size()]);
    }

    public static Object newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return ReflectUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
    }

    public static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            return ReflectUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
    }

    public static Object newInstance(String className, ClassLoader[] classLoaders) {
        ClassNotFoundException e2 = null;
        Class<?> clazz = null;
        ClassLoader[] classLoaderArray = classLoaders;
        int n2 = classLoaders.length;
        int n3 = 0;
        while (n3 < n2) {
            ClassLoader classLoader = classLoaderArray[n3];
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                e2 = ex;
            }
            ++n3;
        }
        if (clazz == null) {
            throw new ReflectException(e2 != null ? e2 : new ClassNotFoundException(className));
        }
        return ReflectUtil.newInstance(clazz);
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object[] initargs) {
        try {
            Class<?> clazz = Class.forName(className);
            return ReflectUtil.newInstance(clazz, parameterTypes, initargs);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object[] initargs, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            return ReflectUtil.newInstance(clazz, parameterTypes, initargs);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectException(e3);
        }
    }

    public static Object newInstance(Class<?> clazz, Class<?>[] parameterTypes, Object[] initargs) {
        try {
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(initargs);
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    public static Object getStaticFieldValue(String className, String fieldName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
        return ReflectUtil.getStaticFieldValue(clazz, fieldName);
    }

    public static Object getStaticFieldValue(Class<?> clazz, String fieldName) {
        Field f2 = ReflectUtil.getField(clazz, fieldName);
        if (f2 == null) {
            return null;
        }
        f2.setAccessible(true);
        Object result = null;
        try {
            result = f2.get(null);
        }
        catch (IllegalArgumentException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectException(e3);
        }
        return result;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field f2 = ReflectUtil.getField(obj.getClass(), fieldName);
        if (f2 == null) {
            return null;
        }
        f2.setAccessible(true);
        Object result = null;
        try {
            result = f2.get(obj);
        }
        catch (IllegalArgumentException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectException(e3);
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object newValue) {
        Field f2 = ReflectUtil.getField(obj.getClass(), fieldName);
        if (f2 == null) {
            return;
        }
        f2.setAccessible(true);
        try {
            f2.set(obj, newValue);
        }
        catch (IllegalArgumentException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectException(e3);
        }
    }

    public static void setStaticFieldValue(Class<?> clazz, String fieldName, Object newValue) {
        Field f2 = ReflectUtil.getField(clazz, fieldName);
        if (f2 == null) {
            return;
        }
        f2.setAccessible(true);
        try {
            f2.set(null, newValue);
        }
        catch (IllegalArgumentException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ReflectException(e3);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        Field f2 = null;
        try {
            f2 = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            f2 = ReflectUtil.getField(clazz.getSuperclass(), fieldName);
        }
        return f2;
    }

    public static Field getField(String className, String fieldName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
        return ReflectUtil.getField(clazz, fieldName);
    }

    public static Method getMethod(String className, String methodName) {
        return ReflectUtil.getMethod(className, methodName, EMPTY_PARAMETER_TYPES);
    }

    public static Method getMethod(String className, String methodName, Class<?>[] parameterTypes) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectException(e2);
        }
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return ReflectUtil.getMethod(clazz, methodName, EMPTY_PARAMETER_TYPES);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        if (clazz == null) {
            return null;
        }
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = ReflectUtil.getMethod(clazz.getSuperclass(), methodName, parameterTypes);
        }
        return method;
    }

    public static Object executeMethod(Object obj, String methodName) {
        return ReflectUtil.executeMethod(obj, methodName, EMPTY_PARAMETER_TYPES, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectUtil.getMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            return null;
        }
        return ReflectUtil.executeMethod(method, obj, args);
    }

    public static Object executeMethod(Method method) {
        return ReflectUtil.executeMethod(method, null, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Method method, Object[] args) {
        return ReflectUtil.executeMethod(method, null, args);
    }

    public static Object executeMethod(Method method, Object obj) {
        return ReflectUtil.executeMethod(method, obj, EMPTY_ARGUMENTS);
    }

    public static Object executeMethod(Method method, Object obj, Object[] args) {
        if (method == null) {
            return null;
        }
        Object result = null;
        method.setAccessible(true);
        try {
            result = method.invoke(obj, args);
        }
        catch (IllegalAccessException e2) {
            throw new ReflectException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw new ReflectException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ReflectException(e4.getCause());
        }
        return result;
    }

    public static Object getPropertyValue(Object bean, String name) {
        if (bean == null) {
            throw new ReflectException("No bean specified");
        }
        if (name == null) {
            throw new ReflectException("No name specified");
        }
        PropertyDescriptor descriptor = ReflectUtil.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new ReflectException("Unknown property '" + name + "'");
        }
        return ReflectUtil.executeMethod(descriptor.getReadMethod(), bean, EMPTY_ARGUMENTS);
    }

    public static void setPropertyValue(Object bean, String name, Object value) {
        if (bean == null) {
            throw new ReflectException("No bean specified");
        }
        if (name == null) {
            throw new ReflectException("No name specified");
        }
        PropertyDescriptor descriptor = ReflectUtil.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new ReflectException("Unknown property '" + name + "'");
        }
        Object[] values = new Object[]{value};
        ReflectUtil.executeMethod(descriptor.getWriteMethod(), bean, values);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) {
        if (bean == null) {
            throw new ReflectException("No bean specified");
        }
        if (name == null) {
            throw new ReflectException("No name specified");
        }
        PropertyDescriptor[] descriptors = ReflectUtil.getPropertyDescriptors(bean.getClass());
        if (descriptors != null) {
            PropertyDescriptor[] propertyDescriptorArray = descriptors;
            int n2 = descriptors.length;
            int n3 = 0;
            while (n3 < n2) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n3];
                if (name.equals(descriptor.getName())) {
                    return descriptor;
                }
                ++n3;
            }
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        PropertyDescriptor[] descriptors = descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ReflectUtil.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?>[] getTypes(Object[] objects) {
        if (objects == null) {
            return new Class[0];
        }
        Class[] classes = new Class[objects.length];
        int i2 = 0;
        while (i2 < objects.length) {
            classes[i2] = objects[i2] == null ? null : objects[i2].getClass();
            ++i2;
        }
        return classes;
    }

    public static boolean isEqualsMethod(Method method) {
        return method != null && method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static class ReflectException
    extends RuntimeException {
        private static final long serialVersionUID = -7130777172290113075L;

        public ReflectException() {
        }

        public ReflectException(String message) {
            super(message);
        }

        public ReflectException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectException(Throwable cause) {
            super(cause);
        }
    }
}

