/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class StringUtil {
    public static final String EMPTY = "";
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "/n");
    public static final String BLANK_SPACE = " ";
    public static final String BLANK_SPACE_WITH_FULL_WIDTH = "\u3000";
    public static final int yyyy_MM_dd_HH_mm_ss = 2;

    static {
        int i2 = -128;
        while (i2 <= 127) {
            StringUtil.allBytes[i2 - -128] = (byte)i2;
            ++i2;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        int i3 = 0;
        while (i3 < 255 && i3 < allBytesStringLen) {
            StringUtil.byteToChars[i3] = allBytesString.charAt(i3);
            ++i3;
        }
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtil.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i2 = 0;
        while (i2 < length) {
            charArray[i2] = byteToChars[buffer[readpoint] - -128];
            ++readpoint;
            ++i2;
        }
        return new String(charArray);
    }

    public static final char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        int i2 = 0;
        while (i2 < length) {
            char c2 = searchIn.charAt(i2);
            if (!Character.isWhitespace(c2)) {
                return Character.toUpperCase(c2);
            }
            ++i2;
        }
        return '\u0000';
    }

    public static final boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtil.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static final boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, 0, searchFor, startAt, searchFor.length());
    }

    public static final boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtil.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static final String[] split(String s2, String seperators) {
        if (s2 == null || seperators == null) {
            return null;
        }
        int[] foot = new int[s2.length()];
        int count = 0;
        int sLen = s2.length();
        int seperatorsLen = seperators.length();
        int i2 = 0;
        while (i2 < sLen) {
            if (i2 == 0 && sLen >= seperatorsLen && s2.substring(0, seperatorsLen).equals(seperators)) {
                i2 += seperatorsLen - 1;
            } else {
                int j2 = 0;
                while (j2 < seperatorsLen) {
                    if (s2.charAt(i2) == seperators.charAt(j2)) {
                        foot[count] = i2;
                        ++count;
                        break;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        String[] ret = new String[count + 1];
        if (count == 0) {
            ret[0] = s2;
            return ret;
        }
        ret[0] = s2.substring(0, foot[0]);
        int i3 = 1;
        while (i3 < count) {
            ret[i3] = s2.substring(foot[i3 - 1] + 1, foot[i3]);
            ++i3;
        }
        ret[count] = s2.substring(foot[count - 1] + 1, s2.length());
        return ret;
    }

    public static final String getEscObjName(String name) {
        String escName = EMPTY;
        if (name == null || name.indexOf("\"") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("\"", index)) == -1) break;
            escName = String.valueOf(escName) + name.substring(index, index2 + 1);
            escName = String.valueOf(escName) + "\"";
            index = index2 + 1;
        }
        escName = String.valueOf(escName) + name.substring(index);
        return escName;
    }

    public static final String getEscStringName(String name) {
        String escName = EMPTY;
        if (name == null || name.indexOf("'") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("'", index)) == -1) break;
            escName = String.valueOf(escName) + name.substring(index, index2 + 1);
            escName = String.valueOf(escName) + "'";
            index = index2 + 1;
        }
        escName = String.valueOf(escName) + name.substring(index);
        return escName;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return null;
        }
        return ("r" + str).trim().substring(1);
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String formatDateTimeString(Date date, int style) {
        String value = null;
        int year = date.getYear();
        int month = date.getMonth();
        String day = StringUtil.getStrFromInt(date.getDate());
        String hour = StringUtil.getStrFromInt(date.getHours());
        String minute = StringUtil.getStrFromInt(date.getMinutes());
        String second = StringUtil.getStrFromInt(date.getSeconds());
        switch (style) {
            case 2: {
                value = year + 1900 + "-" + StringUtil.getStrFromInt(month + 1) + "-" + day + BLANK_SPACE + hour + ":" + minute + ":" + second;
                break;
            }
            default: {
                value = date.toString();
            }
        }
        return value;
    }

    private static String getStrFromInt(int i2) {
        if (i2 < 10) {
            return "0" + i2;
        }
        return String.valueOf(i2);
    }

    public static String formatDir(String dir) {
        if (StringUtil.isNotEmpty(dir = StringUtil.trimToEmpty(dir)) && !dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        return dir;
    }

    public static boolean isDigit(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        int sz = str.length();
        int i2 = 0;
        while (i2 < sz) {
            if (!Character.isDigit(str.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static String printObject(Object obj) {
        if (obj instanceof Properties) {
            String str = EMPTY;
            Properties props = (Properties)obj;
            for (Map.Entry<Object, Object> element : props.entrySet()) {
                str = String.valueOf(str) + element.getKey().toString() + "=" + element.getValue().toString() + ", ";
            }
            return str;
        }
        return obj.toString();
    }

    public static String append(String[] objs) {
        if (objs == null || objs.length == 0) {
            return EMPTY;
        }
        StringBuilder str = new StringBuilder();
        int i2 = 0;
        while (i2 < objs.length) {
            if (i2 != 0) {
                str.append(",");
            }
            str.append(objs[i2]);
            ++i2;
        }
        return str.toString();
    }

    public static String append(String str, int count) {
        StringBuilder sf = new StringBuilder();
        int i2 = 0;
        while (i2 < count) {
            if (i2 != 0) {
                sf.append(",");
            }
            sf.append(str);
            ++i2;
        }
        return sf.toString();
    }

    public static String formatTime() {
        return StringUtil.formatDateTimeString(new Timestamp(System.currentTimeMillis()), 2);
    }

    public static String formatTime(String prefix, String suffix) {
        return String.valueOf(prefix) + StringUtil.formatTime() + suffix;
    }

    public static String processDoubleQuoteOfName(String name) {
        return StringUtil.processQuoteOfName(name, "\"");
    }

    public static String processDoubleQuoteOfNameForLink(String name) {
        return "\"" + StringUtil.processDoubleQuoteOfName(name) + "\"";
    }

    public static String processSingleQuoteOfName(String name) {
        return StringUtil.processQuoteOfName(name, "'");
    }

    public static String processQuoteOfName(String name, String quote) {
        if (StringUtil.isEmpty(quote) || name == null) {
            return name;
        }
        String temp = name;
        StringBuilder result = new StringBuilder();
        int index = -1;
        int quetoLength = quote.length();
        while ((index = temp.indexOf(quote)) != -1) {
            result.append(temp.substring(0, index + quetoLength)).append(quote);
            temp = temp.substring(index + quetoLength);
        }
        result.append(temp);
        return result.toString();
    }
}

