/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dataConvertion.binder.DmBigDecBinder;
import dm.jdbc.dataConvertion.binder.DmBooleanBinder;
import dm.jdbc.dataConvertion.binder.DmByteArrBinder;
import dm.jdbc.dataConvertion.binder.DmByteBinder;
import dm.jdbc.dataConvertion.binder.DmDateBinder;
import dm.jdbc.dataConvertion.binder.DmDmdbTimestampBinder;
import dm.jdbc.dataConvertion.binder.DmDoubleBinder;
import dm.jdbc.dataConvertion.binder.DmFloatBinder;
import dm.jdbc.dataConvertion.binder.DmIntBinder;
import dm.jdbc.dataConvertion.binder.DmIntvDTBinder;
import dm.jdbc.dataConvertion.binder.DmIntvYMBinder;
import dm.jdbc.dataConvertion.binder.DmLongBinder;
import dm.jdbc.dataConvertion.binder.DmShortBinder;
import dm.jdbc.dataConvertion.binder.DmStringBinder;
import dm.jdbc.dataConvertion.binder.DmTimeBinder;
import dm.jdbc.dataConvertion.binder.DmTimestampBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DTypeInfo;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.Comparison;
import dm.sql.ARRAY;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbSQLOutput;
import dm.sql.DmdbTimestamp;
import dm.sql.STRUCT;
import dm.sql.TypeDescriptor;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeData {
    Object m_dumyData = null;
    int m_offset = 0;
    int m_bufLen;
    byte[] m_dataBuf = null;
    byte[] m_objBlobDescBuf = null;
    boolean m_isFromBlob = false;
    int m_packid = -1;
    Vector<Object> m_objRefArr = new Vector(0);

    TypeData(Object val, byte[] dataBuf) {
        this.m_dumyData = val;
        this.m_offset = 0;
        this.m_bufLen = 0;
        this.m_dataBuf = dataBuf;
    }

    public static TypeData[] toStruct(Object[] objArr, TypeDescriptor desc) throws SQLException {
        int size = desc.getStrctMemSize();
        TypeData[] retData = new TypeData[size];
        int i2 = 0;
        while (i2 < size) {
            if (objArr[i2] == null || objArr[i2] instanceof STRUCT || objArr[i2] instanceof ARRAY) {
                retData[i2] = new TypeData(objArr[i2], null);
            } else if (objArr[i2] instanceof SQLData) {
                String typeName = ((SQLData)objArr[i2]).getSQLTypeName();
                if (typeName != null && typeName.equals(desc.m_fieldsObj[i2].getFulName())) {
                    DmdbSQLOutput stream = new DmdbSQLOutput();
                    ((SQLData)objArr[i2]).writeSQL(stream);
                    STRUCT struct = new STRUCT(TypeData.toStruct(stream.getAttribs(), desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]);
                    retData[i2] = new TypeData(struct, null);
                } else {
                    DBError.throwSQLException(6007);
                }
            } else {
                switch (desc.m_fieldsObj[i2].getDType()) {
                    case 119: 
                    case 121: {
                        retData[i2] = new TypeData(new STRUCT(TypeData.toStruct((Object[])objArr[i2], desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        retData[i2] = new TypeData(new ARRAY(TypeData.toArray((Object[])objArr[i2], desc.m_fieldsObj[i2]), desc.m_fieldsObj[i2]), null);
                        break;
                    }
                    default: {
                        retData[i2] = TypeData.toMemberObj(objArr[i2], desc.m_fieldsObj[i2]);
                    }
                }
            }
            ++i2;
        }
        return retData;
    }

    public static TypeData[] toArray(Object[] objArr, TypeDescriptor desc) throws SQLException {
        int size = objArr.length;
        TypeData[] retData = new TypeData[size];
        int i2 = 0;
        while (i2 < size) {
            if (objArr[i2] == null || objArr[i2] instanceof STRUCT || objArr[i2] instanceof ARRAY) {
                retData[i2] = new TypeData(objArr[i2], null);
            } else {
                switch (desc.m_arrObj.getDType()) {
                    case 119: 
                    case 121: {
                        retData[i2] = new TypeData(new STRUCT(TypeData.toStruct((Object[])objArr[i2], desc.m_arrObj), desc.m_arrObj), null);
                        break;
                    }
                    case 117: 
                    case 122: {
                        if (!(objArr[i2] instanceof Object[]) && desc.m_arrObj.m_arrObj != null) {
                            objArr[i2] = TypeData.makeupObjToArr(objArr[i2], desc.m_arrObj);
                        }
                        retData[i2] = new TypeData(new ARRAY(TypeData.toArray((Object[])objArr[i2], desc.m_arrObj), desc.m_arrObj), null);
                        break;
                    }
                    default: {
                        retData[i2] = TypeData.toMemberObj(objArr[i2], desc.m_arrObj);
                    }
                }
            }
            ++i2;
        }
        return retData;
    }

    private static Object[] makeupObjToArr(Object obj, TypeDescriptor objDesc) throws SQLException {
        int subType;
        int arrType = objDesc.getDType();
        boolean dynamic = true;
        int arrLen = 0;
        if (arrType == 122) {
            dynamic = false;
            arrLen = objDesc.m_length;
        }
        if ((subType = objDesc.m_arrObj.getDTypeInfo().getDType()) == 17 || subType == 18 || subType == 3) {
            String strRet = "";
            if (obj instanceof Integer) {
                strRet = Integer.toBinaryString((Integer)obj);
            } else if (obj instanceof Long) {
                strRet = Long.toBinaryString((Long)obj);
            } else if (obj instanceof String) {
                strRet = (String)obj;
            } else {
                DBError.throwSQLException(6007);
            }
            int prec = dynamic ? strRet.length() : arrLen;
            Object[] ret = new Object[prec];
            byte[] rs = Convertion.String_char_2CType(strRet, prec, subType, objDesc.getServerEncoding());
            int i2 = 0;
            while (i2 < prec) {
                ret[i2] = new Byte(rs[i2]);
                ++i2;
            }
            return ret;
        }
        DBError.throwSQLException(6036);
        return null;
    }

    private static TypeData toMemberObj(Object mem, TypeDescriptor desc) throws SQLException {
        Object retObj = mem;
        byte[] bs = null;
        int scale = desc.m_dTypeInfo.getScale();
        int prec = desc.m_dTypeInfo.getPrec();
        int dtype = desc.m_dTypeInfo.getDType();
        short ltz = desc.m_conn.getClientTz();
        short dbTz = desc.m_conn.getDbTz();
        String serverEncoding = desc.m_conn.getServerEncoding();
        if (mem == null) {
            return new TypeData(null, null);
        }
        if (mem instanceof String) {
            bs = DmStringBinder.toDbBytes((String)mem, dtype, prec, scale, serverEncoding, ltz, dbTz);
        } else if (mem instanceof Integer) {
            bs = DmIntBinder.toDbBytes((Integer)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Short) {
            bs = DmShortBinder.toDbBytes((Short)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Long) {
            bs = DmLongBinder.toDbBytes((Long)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Double) {
            bs = DmDoubleBinder.toDbBytes((Double)mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof Float) {
            bs = DmFloatBinder.toDbBytes(((Float)mem).floatValue(), dtype, prec, scale, serverEncoding);
        } else if (mem instanceof Byte) {
            bs = DmByteBinder.toDbBytes((Byte)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof BigDecimal) {
            bs = DmBigDecBinder.toDbBytes((BigDecimal)mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof Number) {
            BigDecimal tmp = new BigDecimal(String.valueOf(mem));
            bs = DmBigDecBinder.toDbBytes(tmp, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof Date) {
            bs = DmDateBinder.toDbBytes((Date)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Time) {
            bs = DmTimeBinder.toDbBytes((Time)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Timestamp) {
            bs = DmTimestampBinder.toDbBytes((Timestamp)mem, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else if (mem instanceof Blob) {
            if (dtype != 12) {
                DBError.throwSQLException(6007);
            }
            bs = null;
        } else if (mem instanceof Clob) {
            if (dtype != 19) {
                DBError.throwSQLException(6007);
            }
            bs = null;
        } else if (mem instanceof byte[]) {
            bs = DmByteArrBinder.toDbBytes((byte[])mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof Boolean) {
            bs = DmBooleanBinder.toDbBytes((Boolean)mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof DmdbIntervalDT) {
            bs = DmIntvDTBinder.toDbBytes((DmdbIntervalDT)mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof DmdbIntervalYM) {
            bs = DmIntvYMBinder.toDbBytes((DmdbIntervalYM)mem, dtype, prec, scale, serverEncoding);
        } else if (mem instanceof DmdbTimestamp) {
            bs = DmDmdbTimestampBinder.toDbBytes((DmdbTimestamp)mem, dtype, prec, scale, serverEncoding, ltz, dbTz);
        } else if (mem instanceof Character) {
            String str = String.valueOf(mem);
            bs = DmStringBinder.toDbBytes(str, dtype, prec, scale, serverEncoding, ltz, dbTz);
        } else if (mem instanceof java.util.Date) {
            Date date = new Date(((java.util.Date)mem).getTime());
            bs = DmDateBinder.toDbBytes(date, dtype, prec, scale, serverEncoding, ltz, dbTz, null);
        } else {
            DBError.throwUnsupportedSQLException();
        }
        return new TypeData(retObj, bs);
    }

    private static byte[] typeDataToBytes(TypeData data, TypeDescriptor desc) throws SQLException {
        int dType = desc.getDType();
        byte[] innerData = null;
        if (data.m_dumyData == null) {
            innerData = TypeData.realocBuffer(null, 0, 2);
            Convertion.setByte(innerData, 0, (byte)0);
            Convertion.setByte(innerData, 1, (byte)0);
            return innerData;
        }
        byte[] result = null;
        int offset = 0;
        switch (dType) {
            case 117: {
                innerData = TypeData.arrayToBytes((ARRAY)data.m_dumyData, desc);
                result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                Convertion.setByte(result, 0, (byte)0);
                offset = 1;
                Convertion.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 122: {
                innerData = TypeData.sarrayToBytes((ARRAY)data.m_dumyData, desc);
                result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                Convertion.setByte(result, 0, (byte)0);
                offset = 1;
                Convertion.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 119: {
                innerData = TypeData.objToBytes(data.m_dumyData, desc);
                result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                Convertion.setByte(result, 0, (byte)0);
                offset = 1;
                Convertion.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 121: {
                innerData = TypeData.recordToBytes((STRUCT)data.m_dumyData, desc);
                result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                Convertion.setByte(result, 0, (byte)0);
                offset = 1;
                Convertion.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 12: 
            case 19: {
                innerData = TypeData.convertLobToBytes(data.m_dumyData, desc.getDTypeInfo(), desc.getServerEncoding());
                result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1);
                Convertion.setByte(result, 0, (byte)0);
                offset = 1;
                Convertion.setByte(result, offset, (byte)1);
                System.arraycopy(innerData, 0, result, ++offset, innerData.length);
                return result;
            }
            case 13: {
                innerData = TypeData.realocBuffer(null, 0, 2);
                Convertion.setByte(innerData, 0, (byte)0);
                if (data.m_dataBuf != null && data.m_dataBuf.length > 0) {
                    Convertion.setByte(innerData, 1, data.m_dataBuf[0]);
                } else {
                    Convertion.setByte(innerData, 1, (byte)0);
                }
                return innerData;
            }
        }
        innerData = data.m_dataBuf;
        result = TypeData.realocBuffer(null, 0, innerData.length + 1 + 1 + 2);
        Convertion.setByte(result, 0, (byte)0);
        offset = 1;
        Convertion.setByte(result, offset, (byte)1);
        Convertion.setShort(result, ++offset, (short)innerData.length);
        System.arraycopy(innerData, 0, result, offset += 2, innerData.length);
        return result;
    }

    private static byte[] convertLobToBytes(Object value, DTypeInfo dtypeInfo, String serverEncoding) throws SQLException {
        byte[] tmp = null;
        byte[] ret = null;
        int len = 0;
        if (dtypeInfo.getDType() == 12) {
            DmdbBlob lob = (DmdbBlob)value;
            len = lob.getLobLen();
            tmp = lob.getBytes(1L, len);
            ret = new byte[len + 4];
            Convertion.setInt(ret, 0, len);
            System.arraycopy(tmp, 0, ret, 4, len);
            return ret;
        }
        if (dtypeInfo.getDType() == 19) {
            DmdbClob lob = (DmdbClob)value;
            len = lob.getLobLen();
            String subString = lob.getSubString(1L, len);
            tmp = Convertion.getBytes(subString, serverEncoding);
            ret = new byte[tmp.length + 4];
            Convertion.setInt(ret, 0, len);
            System.arraycopy(tmp, 0, ret, 4, len);
            return ret;
        }
        DBError.throwSQLException(6007);
        return null;
    }

    public static byte[] sarrayToBytes(ARRAY data, TypeDescriptor desc) throws SQLException {
        int realLen = data.m_arrData.length;
        byte[][] results = new byte[realLen][];
        byte[] rdata = null;
        if (desc.getObjId() == 4) {
            return TypeData.ctlnToBytes(data, desc);
        }
        int totalLen = 0;
        int i2 = 0;
        while (i2 < realLen) {
            results[i2] = TypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        rdata = TypeData.realocBuffer(null, 0, totalLen += 8);
        int off = 0;
        Convertion.setInt(rdata, off, totalLen);
        Convertion.setInt(rdata, off += 4, data.m_arrDesc.getLength());
        off += 4;
        int i3 = 0;
        while (i3 < realLen) {
            System.arraycopy(results[i3], 0, rdata, off, results[i3].length);
            off += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] ctlnToBytes(ARRAY data, TypeDescriptor desc) throws SQLException {
        byte[][] results = new byte[data.m_arrData.length][];
        byte[] rdata = null;
        int totalLen = 0;
        totalLen = 5;
        totalLen += 8;
        int i2 = 0;
        while (i2 < data.m_arrData.length) {
            results[i2] = TypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        rdata = TypeData.realocBuffer(null, 0, totalLen);
        int offset = 0;
        Convertion.setByte(rdata, offset, (byte)0);
        ++offset;
        Convertion.setShort(rdata, offset += 4, (short)desc.getCltnType());
        Convertion.setShort(rdata, offset += 2, (short)desc.m_arrObj.getDType());
        Convertion.setInt(rdata, offset += 2, data.m_arrData.length);
        offset += 4;
        int i3 = 0;
        while (i3 < data.m_arrData.length) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        Convertion.setInt(rdata, 1, offset);
        return rdata;
    }

    public static byte[] arrayToBytes(ARRAY data, TypeDescriptor desc) throws SQLException {
        byte[][] results = new byte[data.m_arrData.length][];
        byte[] rdata = null;
        if (desc.getObjId() == 4) {
            return TypeData.ctlnToBytes(data, desc);
        }
        int totalLen = 0;
        int i2 = 0;
        while (i2 < data.m_arrData.length) {
            results[i2] = TypeData.typeDataToBytes(data.m_arrData[i2], desc.m_arrObj);
            totalLen += results[i2].length;
            ++i2;
        }
        totalLen += 20;
        int total = data.m_objCount + data.m_strCount;
        if (total > 0) {
            totalLen += 2 * total;
        }
        rdata = TypeData.realocBuffer(null, 0, totalLen);
        Convertion.setInt(rdata, 0, totalLen);
        int offset = 4;
        Convertion.setInt(rdata, offset, data.m_arrData.length);
        Convertion.setInt(rdata, offset += 4, 0);
        Convertion.setInt(rdata, offset += 4, data.m_objCount);
        Convertion.setInt(rdata, offset += 4, data.m_strCount);
        offset += 4;
        int i3 = 0;
        while (i3 < total) {
            Convertion.setInt(rdata, offset, data.m_objStrOffs[i3]);
            offset += 4;
            ++i3;
        }
        i3 = 0;
        while (i3 < data.m_arrData.length) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] objToBytes(Object data, TypeDescriptor desc) throws SQLException {
        if (data instanceof ARRAY) {
            return TypeData.arrayToBytes((ARRAY)data, desc);
        }
        return TypeData.structToBytes((STRUCT)data, desc);
    }

    public static byte[] structToBytes(STRUCT data, TypeDescriptor desc) throws SQLException {
        int size = desc.getStrctMemSize();
        byte[][] results = new byte[size][];
        byte[] rdata = null;
        int totalLen = 0;
        int i2 = 0;
        while (i2 < size) {
            results[i2] = TypeData.typeDataToBytes(data.m_attribs[i2], desc.m_fieldsObj[i2]);
            totalLen += results[i2].length;
            ++i2;
        }
        rdata = TypeData.realocBuffer(null, 0, totalLen += 5);
        int offset = 0;
        Convertion.setByte(rdata, offset, (byte)0);
        Convertion.setInt(rdata, ++offset, totalLen);
        offset += 4;
        int i3 = 0;
        while (i3 < size) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    public static byte[] recordToBytes(STRUCT data, TypeDescriptor desc) throws SQLException {
        int size = desc.getStrctMemSize();
        byte[][] results = new byte[size][];
        byte[] rdata = null;
        int totalLen = 0;
        int i2 = 0;
        while (i2 < size) {
            results[i2] = TypeData.typeDataToBytes(data.m_attribs[i2], desc.m_fieldsObj[i2]);
            totalLen += results[i2].length;
            ++i2;
        }
        rdata = TypeData.realocBuffer(null, 0, totalLen += 4);
        Convertion.setInt(rdata, 0, totalLen);
        int offset = 4;
        int i3 = 0;
        while (i3 < desc.getStrctMemSize()) {
            System.arraycopy(results[i3], 0, rdata, offset, results[i3].length);
            offset += results[i3].length;
            ++i3;
        }
        return rdata;
    }

    private static TypeData bytesToBlob(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        int offset = out.m_offset;
        int len = Convertion.getInt(val, offset);
        byte[] tmp = Convertion.getBytes(val, offset += 4, len);
        out.m_offset = offset += len;
        return new TypeData(new DmdbBlob(tmp, desc.m_conn), tmp);
    }

    private static TypeData bytesToClob(byte[] val, TypeData out, TypeDescriptor desc, String serverEncoding) throws SQLException {
        int offset = out.m_offset;
        int len = Convertion.getInt(val, offset);
        byte[] tmp = Convertion.getBytes(val, offset += 4, len);
        out.m_offset = offset += len;
        return new TypeData(new DmdbClob(tmp, desc.m_conn), tmp);
    }

    private static TypeData bytesToTypeData(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        int offset = out.m_offset;
        byte null_flag = Convertion.getByte(val, ++offset);
        out.m_offset = ++offset;
        if (desc.getDType() == 13) {
            boolean b2 = false;
            if (null_flag != 0) {
                b2 = true;
            }
            return new TypeData(new Boolean(b2), Convertion.getBytes(val, offset - 1, 1));
        }
        Object retObj = null;
        byte[] retDataBuf = null;
        switch (desc.getDType()) {
            case 119: {
                if ((null_flag & 1) != 0) {
                    retObj = TypeData.bytesToObj(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new TypeData(retObj, retDataBuf);
                }
                return new TypeData(null, null);
            }
            case 117: {
                if ((null_flag & 1) != 0) {
                    retObj = TypeData.bytesToArray(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new TypeData(retObj, retDataBuf);
                }
                return new TypeData(null, null);
            }
            case 121: {
                if ((null_flag & 1) != 0) {
                    retObj = TypeData.bytesToRecord(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new TypeData(retObj, retDataBuf);
                }
                return new TypeData(null, null);
            }
            case 122: {
                if ((null_flag & 1) != 0) {
                    retObj = TypeData.bytesToSArray(val, out, desc);
                    if (out.m_offset > offset) {
                        retDataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
                    }
                    return new TypeData(retObj, retDataBuf);
                }
                return new TypeData(null, null);
            }
            case 12: {
                if ((null_flag & 1) != 0) {
                    return TypeData.bytesToBlob(val, out, desc);
                }
                return new TypeData(null, null);
            }
            case 19: {
                if ((null_flag & 1) != 0) {
                    return TypeData.bytesToClob(val, out, desc, desc.getServerEncoding());
                }
                return new TypeData(null, null);
            }
        }
        if ((null_flag & 1) != 0) {
            return TypeData.convertBytes2BaseData(desc.accessor, val, out);
        }
        return new TypeData(null, null);
    }

    private static boolean checkObjExist(byte[] val, TypeData out) {
        int offset = out.m_offset;
        byte exist_flag = Convertion.getByte(val, offset);
        out.m_offset = ++offset;
        if (exist_flag == 1) {
            return true;
        }
        out.m_offset += 4;
        return false;
    }

    private static STRUCT findObjByPackId(byte[] val, TypeData out) throws SQLException {
        int offset = out.m_offset;
        int pack_id = Convertion.getInt(val, offset);
        out.m_offset = offset += 4;
        if (pack_id < 0 || pack_id > out.m_packid) {
            DBError.throwSQLException(6007);
        }
        return (STRUCT)out.m_objRefArr.get(pack_id);
    }

    private static void addObjToRefArr(TypeData out, Object objToAdd) {
        out.m_objRefArr.add(objToAdd);
        ++out.m_packid;
    }

    private static boolean checkObjClnt(TypeDescriptor desc) {
        return desc.m_objId == 4;
    }

    private static STRUCT bytesToObj_EXACT(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        STRUCT strOut = new STRUCT(null, desc);
        int offset = out.m_offset;
        int size = desc.getStrctMemSize();
        out.m_offset = offset;
        strOut.m_attribs = new TypeData[size];
        int i2 = 0;
        while (i2 < size) {
            TypeDescriptor sub_desc = desc.m_fieldsObj[i2];
            strOut.m_attribs[i2] = TypeData.bytesToTypeData(val, out, sub_desc);
            ++i2;
        }
        strOut.m_dataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
        return strOut;
    }

    private static ARRAY bytesToNestTab(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        int offset = out.m_offset;
        int count = Convertion.getInt(val, offset += 2);
        out.m_offset = offset += 4;
        ARRAY arrOut = new ARRAY(null, desc);
        arrOut.m_itemCount = count;
        arrOut.m_arrData = new TypeData[count];
        int i2 = 0;
        while (i2 < count) {
            arrOut.m_arrData[i2] = TypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    private static ARRAY bytesToClnt(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        ARRAY array = null;
        int offset = out.m_offset;
        short cltn_type = Convertion.getShort(val, offset);
        out.m_offset = offset += 2;
        switch (cltn_type) {
            case 3: {
                DBError.throwUnsupportedSQLException();
                break;
            }
            case 1: 
            case 2: {
                array = TypeData.bytesToNestTab(val, out, desc);
            }
        }
        return array;
    }

    public static Object bytesToObj(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        TypeData retObj = null;
        if (out == null) {
            out = new TypeData(null, null);
        }
        if (TypeData.checkObjExist(val, out)) {
            retObj = TypeData.findObjByPackId(val, out);
        } else {
            TypeData.addObjToRefArr(out, retObj);
            retObj = TypeData.checkObjClnt(desc) ? TypeData.bytesToClnt(val, out, desc) : TypeData.bytesToObj_EXACT(val, out, desc);
        }
        return retObj;
    }

    public static ARRAY bytesToArray(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        ARRAY arrOut = new ARRAY(null, desc);
        if (out == null) {
            out = new TypeData(null, null);
        }
        int offset = out.m_offset;
        arrOut.m_bufLen = Convertion.getInt(val, offset);
        arrOut.m_itemCount = Convertion.getInt(val, offset += 4);
        arrOut.m_itemSize = Convertion.getInt(val, offset += 4);
        arrOut.m_objCount = Convertion.getInt(val, offset += 4);
        arrOut.m_strCount = Convertion.getInt(val, offset += 4);
        offset += 4;
        int total = arrOut.m_objCount + arrOut.m_strCount;
        arrOut.m_objStrOffs = new int[total];
        int i2 = 0;
        while (i2 < total) {
            arrOut.m_objStrOffs[i2] = Convertion.getInt(val, offset);
            offset += 4;
            ++i2;
        }
        out.m_offset = offset;
        arrOut.m_arrData = new TypeData[arrOut.m_itemCount];
        i2 = 0;
        while (i2 < arrOut.m_itemCount) {
            arrOut.m_arrData[i2] = TypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    public static ARRAY bytesToSArray(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        if (out == null) {
            out = new TypeData(null, null);
        }
        int offset = out.m_offset;
        ARRAY arrOut = new ARRAY(null, desc);
        arrOut.m_bufLen = Convertion.getInt(val, offset);
        arrOut.m_itemCount = Convertion.getInt(val, offset += 4);
        out.m_offset = offset += 4;
        arrOut.m_arrData = new TypeData[arrOut.m_itemCount];
        int i2 = 0;
        while (i2 < arrOut.m_itemCount) {
            arrOut.m_arrData[i2] = TypeData.bytesToTypeData(val, out, desc.m_arrObj);
            ++i2;
        }
        arrOut.m_dataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
        return arrOut;
    }

    public static STRUCT bytesToRecord(byte[] val, TypeData out, TypeDescriptor desc) throws SQLException {
        if (out == null) {
            out = new TypeData(null, null);
        }
        int offset = out.m_offset;
        STRUCT strOut = new STRUCT(null, desc);
        strOut.m_bufLen = Convertion.getInt(val, offset);
        out.m_offset = offset += 4;
        strOut.m_attribs = new TypeData[desc.getStrctMemSize()];
        int i2 = 0;
        while (i2 < desc.getStrctMemSize()) {
            strOut.m_attribs[i2] = TypeData.bytesToTypeData(val, out, desc.m_fieldsObj[i2]);
            ++i2;
        }
        strOut.m_dataBuf = Convertion.getBytes(val, offset, out.m_offset - offset);
        return strOut;
    }

    private static void objBlob_GetChkBuf(byte[] buf, TypeData typeData) {
        int offset = 4;
        int len = Convertion.getInt(buf, offset);
        typeData.m_objBlobDescBuf = Convertion.getBytes(buf, offset += 4, len);
        typeData.m_isFromBlob = true;
        typeData.m_offset = offset += len;
    }

    public static Object objBlobToObj(Blob lob, TypeDescriptor desc) throws SQLException {
        TypeData typeData = new TypeData(null, null);
        int loblen = (int)lob.length();
        byte[] buf = lob.getBytes(1L, loblen);
        TypeData.objBlob_GetChkBuf(buf, typeData);
        return TypeData.bytesToObj(buf, typeData, desc);
    }

    public static byte[] objBlobToBytes(byte[] lobBuf, TypeDescriptor desc) throws SQLException {
        int descLen;
        byte[] descBuf;
        int len = lobBuf.length;
        byte[] buf = lobBuf;
        int offset = 0;
        int magic = Convertion.getInt(buf, offset);
        offset += 4;
        if (78111999 != magic) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.invalidObjBlob"));
        }
        if (Comparison.compareBytes(descBuf = Convertion.getBytes(buf, offset += 4, descLen = Convertion.getInt(buf, offset)), desc.getClassDescChkInfo()) != 0) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.invalidObjBlob"));
        }
        byte[] ret = new byte[len - (offset += descLen)];
        System.arraycopy(buf, offset, ret, 0, ret.length);
        return ret;
    }

    private static byte[] realocBuffer(byte[] oldBuf, int offset, int needLen) {
        byte[] retBuf = null;
        if (oldBuf == null) {
            return new byte[needLen];
        }
        if (needLen + offset > oldBuf.length) {
            retBuf = new byte[oldBuf.length + needLen];
            System.arraycopy(oldBuf, 0, retBuf, 0, offset);
        } else {
            retBuf = oldBuf;
        }
        return retBuf;
    }

    private static TypeData convertBytes2BaseData(BaseAccessor accessor, byte[] val, TypeData out) throws SQLException {
        int offset = out.m_offset;
        boolean isNull = false;
        int valueLen = Convertion.getShort(val, offset);
        offset += 2;
        if (valueLen == 65534) {
            valueLen = 0;
            isNull = true;
        }
        if (-1 == valueLen) {
            valueLen = Convertion.getInt(val, offset);
            offset += 4;
        }
        if (isNull) {
            out.m_offset = offset;
            return new TypeData(null, null);
        }
        Object tmpObj = null;
        byte[] temp = Convertion.getBytes(val, offset, valueLen);
        out.m_offset = offset += valueLen;
        if (accessor != null) {
            accessor.setOutValue(temp);
            tmpObj = accessor.getDtype() == 3 ? Byte.valueOf(accessor.getByte()) : accessor.getObject(null);
        } else {
            DBError.throwUnsupportedSQLException();
            tmpObj = null;
        }
        return new TypeData(tmpObj, temp);
    }

    public Object toJavaArray(ARRAY arr, int len, int dType) throws SQLException {
        return this.toJavaArray(arr, 1L, len, dType);
    }

    public Object toJavaArray(ARRAY arr, long index, int len, int dType) throws SQLException {
        if (arr.m_objArray != null) {
            return arr.m_objArray;
        }
        Object nr = null;
        int realIdx = (int)(index - 1L);
        TypeData tempData = null;
        switch (dType) {
            case 0: 
            case 1: 
            case 2: {
                nr = new String[len];
                int i2 = 0;
                while (i2 < len) {
                    tempData = arr.m_arrData[realIdx + i2];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((String[])nr)[i2] = new String((String)tempData.m_dumyData);
                    }
                    ++i2;
                }
                break;
            }
            case 3: 
            case 5: {
                nr = new Byte[len];
                int i3 = 0;
                while (i3 < len) {
                    tempData = arr.m_arrData[realIdx + i3];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Byte[])nr)[i3] = new Byte((Byte)tempData.m_dumyData);
                    }
                    ++i3;
                }
                break;
            }
            case 17: 
            case 18: {
                nr = new byte[len][];
                int i4 = 0;
                while (i4 < len) {
                    byte[] temp;
                    tempData = arr.m_arrData[realIdx + i4];
                    if (tempData != null && tempData.m_dumyData != null && (temp = (byte[])tempData.m_dumyData).length > 0) {
                        ((byte[][])nr)[i4] = temp;
                    }
                    ++i4;
                }
                break;
            }
            case 13: {
                nr = new Boolean[len];
                int i5 = 0;
                while (i5 < len) {
                    tempData = arr.m_arrData[realIdx + i5];
                    ((Boolean[])nr)[i5] = tempData != null && tempData.m_dumyData != null ? new Boolean((Boolean)tempData.m_dumyData) : null;
                    ++i5;
                }
                break;
            }
            case 6: {
                nr = new Short[len];
                int i6 = 0;
                while (i6 < len) {
                    tempData = arr.m_arrData[realIdx + i6];
                    ((Short[])nr)[i6] = tempData != null && tempData.m_dumyData != null ? new Short((Short)tempData.m_dumyData) : null;
                    ++i6;
                }
                break;
            }
            case 7: {
                nr = new Integer[len];
                int i7 = 0;
                while (i7 < len) {
                    tempData = arr.m_arrData[realIdx + i7];
                    ((Integer[])nr)[i7] = tempData != null && tempData.m_dumyData != null ? new Integer((Integer)tempData.m_dumyData) : null;
                    ++i7;
                }
                break;
            }
            case 8: {
                nr = new Long[len];
                int i8 = 0;
                while (i8 < len) {
                    tempData = arr.m_arrData[realIdx + i8];
                    ((Long[])nr)[i8] = tempData != null && tempData.m_dumyData != null ? new Long((Long)tempData.m_dumyData) : null;
                    ++i8;
                }
                break;
            }
            case 9: {
                nr = new BigDecimal[len];
                int i9 = 0;
                while (i9 < len) {
                    tempData = arr.m_arrData[realIdx + i9];
                    ((BigDecimal[])nr)[i9] = tempData != null && tempData.m_dumyData != null ? new BigDecimal(String.valueOf(tempData.m_dumyData)) : null;
                    ++i9;
                }
                break;
            }
            case 10: {
                nr = new Float[len];
                int i10 = 0;
                while (i10 < len) {
                    tempData = arr.m_arrData[realIdx + i10];
                    ((Float[])nr)[i10] = tempData != null && tempData.m_dumyData != null ? new Float(((Float)tempData.m_dumyData).floatValue()) : null;
                    ++i10;
                }
                break;
            }
            case 11: {
                nr = new Double[len];
                int i11 = 0;
                while (i11 < len) {
                    tempData = arr.m_arrData[realIdx + i11];
                    ((Double[])nr)[i11] = tempData != null && tempData.m_dumyData != null ? new Double((Double)tempData.m_dumyData) : null;
                    ++i11;
                }
                break;
            }
            case 14: {
                nr = new Date[len];
                int i12 = 0;
                while (i12 < len) {
                    tempData = arr.m_arrData[realIdx + i12];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Date[])nr)[i12] = (Date)tempData.m_dumyData;
                    }
                    ++i12;
                }
                break;
            }
            case 15: {
                nr = new Time[len];
                int i13 = 0;
                while (i13 < len) {
                    tempData = arr.m_arrData[realIdx + i13];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Time[])nr)[i13] = (Time)tempData.m_dumyData;
                    }
                    ++i13;
                }
                break;
            }
            case 16: {
                nr = new Timestamp[len];
                int i14 = 0;
                while (i14 < len) {
                    tempData = arr.m_arrData[realIdx + i14];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((Timestamp[])nr)[i14] = (Timestamp)tempData.m_dumyData;
                    }
                    ++i14;
                }
                break;
            }
            case 20: {
                nr = new DmdbIntervalYM[len];
                int i15 = 0;
                while (i15 < len) {
                    tempData = arr.m_arrData[realIdx + i15];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbIntervalYM[])nr)[i15] = (DmdbIntervalYM)tempData.m_dumyData;
                    }
                    ++i15;
                }
                break;
            }
            case 21: {
                nr = new DmdbIntervalDT[len];
                int i16 = 0;
                while (i16 < len) {
                    tempData = arr.m_arrData[realIdx + i16];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbIntervalDT[])nr)[i16] = (DmdbIntervalDT)tempData.m_dumyData;
                    }
                    ++i16;
                }
                break;
            }
            case 22: 
            case 23: {
                nr = new DmdbTimestamp[len];
                int i17 = 0;
                while (i17 < len) {
                    tempData = arr.m_arrData[realIdx + i17];
                    if (tempData != null && tempData.m_dumyData != null) {
                        ((DmdbTimestamp[])nr)[i17] = (DmdbTimestamp)tempData.m_dumyData;
                    }
                    ++i17;
                }
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                nr = new Object[len];
                int i18 = 0;
                while (i18 < len) {
                    tempData = arr.m_arrData[realIdx + i18];
                    if (tempData != null && tempData.m_dumyData != null) {
                        if (tempData.m_dumyData instanceof ARRAY) {
                            nr[i18] = (ARRAY)tempData.m_dumyData;
                        } else if (tempData.m_dumyData instanceof STRUCT) {
                            nr[i18] = (STRUCT)tempData.m_dumyData;
                        }
                    } else {
                        nr[i18] = null;
                    }
                    ++i18;
                }
                break;
            }
            case 12: {
                nr = new DmdbBlob[len];
                int i19 = 0;
                while (i19 < len) {
                    tempData = arr.m_arrData[realIdx + i19];
                    ((DmdbBlob[])nr)[i19] = tempData != null && tempData.m_dumyData != null ? (DmdbBlob)((DmdbBlob)tempData.m_dumyData).clone() : null;
                    ++i19;
                }
                break;
            }
            case 19: {
                nr = new DmdbClob[len];
                int i20 = 0;
                while (i20 < len) {
                    tempData = arr.m_arrData[realIdx + i20];
                    ((DmdbClob[])nr)[i20] = tempData != null && tempData.m_dumyData != null ? (DmdbClob)((DmdbClob)tempData.m_dumyData).clone() : null;
                    ++i20;
                }
                break;
            }
            default: {
                DBError.throwUnsupportedSQLException();
                return null;
            }
        }
        return nr;
    }

    Object toNumericArray(ARRAY arr, long index, int len, int flag) throws SQLException {
        if (arr.m_objArray == null) {
            return null;
        }
        int realIdx = (int)(index - 1L);
        Object[] retObj = null;
        if (flag == 1 && arr.m_objArray instanceof short[]) {
            short[] ret = new short[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 2 && arr.m_objArray instanceof int[]) {
            int[] ret = new int[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 3 && arr.m_objArray instanceof long[]) {
            long[] ret = new long[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 4 && arr.m_objArray instanceof float[]) {
            float[] ret = new float[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        } else if (flag == 5 && arr.m_objArray instanceof double[]) {
            double[] ret = new double[len];
            System.arraycopy(arr.m_objArray, realIdx, ret, 0, len);
            retObj = ret;
        }
        DBError.throwSQLException(6007);
        return retObj;
    }

    Object toJava(Object value, Map<String, Class<?>> map) {
        return value;
    }

    Object[] toJavaArray(STRUCT struct) throws SQLException {
        TypeData[] attrsData = struct.getAttribsTypeData();
        if (struct.getAttribsTypeData() == null || struct.getAttribsTypeData().length <= 0) {
            return null;
        }
        TypeDescriptor[] fields = struct.m_strctDesc.getItemsDesc();
        if (attrsData.length != fields.length) {
            throw new SQLException(DmSvcConf.res.getString("error.structMemNotMatch"));
        }
        Object[] out = new Object[fields.length];
        int i2 = 0;
        while (i2 < fields.length) {
            out[i2] = this.toJava(attrsData[i2].m_dumyData, null);
            ++i2;
        }
        return out;
    }

    public static byte[] toBytes(TypeData x2, TypeDescriptor typeDesc) throws SQLException {
        byte[] desc = typeDesc.getClassDescChkInfo();
        byte[] data = null;
        switch (typeDesc.getDType()) {
            case 117: {
                data = TypeData.arrayToBytes((ARRAY)x2, typeDesc);
                break;
            }
            case 122: {
                data = TypeData.sarrayToBytes((ARRAY)x2, typeDesc);
                break;
            }
            case 121: {
                data = TypeData.recordToBytes((STRUCT)x2, typeDesc);
                break;
            }
            case 119: {
                data = TypeData.objToBytes(x2, typeDesc);
                break;
            }
        }
        byte[] ret = new byte[8 + desc.length + data.length];
        Convertion.setInt(ret, 0, 78111999);
        Convertion.setInt(ret, 4, desc.length);
        System.arraycopy(desc, 0, ret, 8, desc.length);
        System.arraycopy(data, 0, ret, 8 + desc.length, data.length);
        return ret;
    }
}

