/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.desc.CommDesc;
import dm.jdbc.desc.DTypeInfo;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.sql.SQLName;
import java.io.Serializable;
import java.sql.SQLException;

public class TypeDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    LobDesc m_lobDesc = null;
    DTypeInfo m_dTypeInfo = null;
    SQLName m_sqlName = null;
    int m_objId = -1;
    int m_objVersion = -1;
    int m_outerId = 0;
    int m_outerVer = 0;
    int m_subId = 0;
    int m_cltnType = 0;
    int m_maxCnt = 0;
    int m_length = 0;
    int m_size = 0;
    DmdbConnection_bs m_conn = null;
    private String m_serverEncoding = null;
    public TypeDescriptor m_arrObj = null;
    public TypeDescriptor[] m_fieldsObj = null;
    byte[] m_descBuf = null;
    BaseAccessor accessor = null;

    public TypeDescriptor(String fulName, DmdbConnection_bs conn) {
        this.m_sqlName = new SQLName(fulName);
        this.m_dTypeInfo = new DTypeInfo();
        this.m_conn = conn;
    }

    public TypeDescriptor(DmdbConnection_bs conn) {
        this.m_dTypeInfo = new DTypeInfo();
        this.m_sqlName = new SQLName(conn);
        this.m_conn = conn;
    }

    public DTypeInfo getDTypeInfo() {
        return this.m_dTypeInfo;
    }

    public void parseDescByName() throws SQLException {
        String sql = "BEGIN ? = SF_DESCRIBE_TYPE(?); END;";
        DmdbCallableStatement_bs cstmt = (DmdbCallableStatement_bs)this.m_conn.prepareCall(sql);
        cstmt.setString(2, this.m_sqlName.m_fulName);
        cstmt.registerOutParameter(1, 2004);
        cstmt.execute();
        DmdbBlob blob = (DmdbBlob)cstmt.getBlob(1);
        int lobLen = blob.getLobLen();
        byte[] buf = blob.getBytes(1L, lobLen);
        this.m_serverEncoding = this.m_conn.getServerEncoding();
        this.unpack(buf, 0);
        cstmt.close();
        cstmt = null;
    }

    public String getFulName() throws SQLException {
        return this.m_sqlName.getFulName();
    }

    public int getDType() {
        return this.m_dTypeInfo.getDType();
    }

    public int getPrec() {
        return this.m_dTypeInfo.getPrec();
    }

    public int getScale() {
        return this.m_dTypeInfo.getScale();
    }

    public String getServerEncoding() {
        return this.m_serverEncoding == null ? this.m_conn.getServerEncoding() : this.m_serverEncoding;
    }

    public int getObjId() {
        return this.m_objId;
    }

    public int getObjVersion() {
        return this.m_objVersion;
    }

    public int getStaticArrayLength() {
        return this.m_length;
    }

    public int getStrctMemSize() {
        return this.m_size;
    }

    public int getOuterId() {
        return this.m_outerId;
    }

    public int getCltnType() {
        return this.m_cltnType;
    }

    public int getOuterVer() {
        return this.m_outerVer;
    }

    public int getSubId() {
        return this.m_subId;
    }

    public int getMaxCnt() {
        return this.m_maxCnt;
    }

    private static int getPackSize(TypeDescriptor typeDesc) throws SQLException {
        int len = 0;
        switch (typeDesc.m_dTypeInfo.getDType()) {
            case 117: 
            case 122: {
                return TypeDescriptor.getPackArraySize(typeDesc);
            }
            case 119: {
                return TypeDescriptor.getPackClassSize(typeDesc);
            }
            case 121: {
                return TypeDescriptor.getPackRecordSize(typeDesc);
            }
        }
        len += 4;
        len += 4;
        return len += 4;
    }

    private static void pack(TypeDescriptor typeDesc, DmMsgSend msg) throws SQLException {
        switch (typeDesc.m_dTypeInfo.getDType()) {
            case 117: 
            case 122: {
                TypeDescriptor.packArray(typeDesc, msg);
                return;
            }
            case 119: {
                TypeDescriptor.packClass(typeDesc, msg);
                return;
            }
            case 121: {
                TypeDescriptor.packRecord(typeDesc, msg);
                return;
            }
        }
        msg.setInt(typeDesc.m_dTypeInfo.getDType());
        msg.setInt(typeDesc.m_dTypeInfo.getPrec());
        msg.setInt(typeDesc.m_dTypeInfo.getScale());
    }

    public static int getPackArraySize(TypeDescriptor arrDesc) throws SQLException {
        int len = 0;
        len += 4;
        String name = arrDesc.m_sqlName.m_name;
        len += 2;
        String serverEncoding = arrDesc.getServerEncoding();
        byte[] ret = Convertion.getBytes(name, serverEncoding);
        len += ret.length;
        len += 4;
        len += 4;
        len += 4;
        return len += TypeDescriptor.getPackSize(arrDesc.m_arrObj);
    }

    public static void packArray(TypeDescriptor arrDesc, DmMsgSend msg) throws SQLException {
        msg.setInt(arrDesc.m_dTypeInfo.getDType());
        String name = arrDesc.m_sqlName.m_name;
        msg.setShort(name.length());
        String serverEncoding = arrDesc.getServerEncoding();
        msg.setString(name, serverEncoding);
        msg.setInt(arrDesc.m_objId);
        msg.setInt(arrDesc.m_objVersion);
        msg.setInt(arrDesc.m_length);
        TypeDescriptor.pack(arrDesc.m_arrObj, msg);
    }

    public static void packRecord(TypeDescriptor strctDesc, DmMsgSend msg) throws SQLException {
        msg.setInt(strctDesc.m_dTypeInfo.getDType());
        String name = strctDesc.m_sqlName.m_name;
        msg.setShort(name.length());
        String serverEncoding = strctDesc.getServerEncoding();
        msg.setString(name, serverEncoding);
        msg.setInt(strctDesc.m_objId);
        msg.setInt(strctDesc.m_objVersion);
        msg.setShort(strctDesc.m_size);
        int i2 = 0;
        while (i2 < strctDesc.m_size) {
            TypeDescriptor.pack(strctDesc.m_fieldsObj[i2], msg);
            ++i2;
        }
    }

    public static int getPackRecordSize(TypeDescriptor strctDesc) throws SQLException {
        int len = 0;
        len += 4;
        String name = strctDesc.m_sqlName.m_name;
        len += 2;
        String serverEncoding = strctDesc.getServerEncoding();
        byte[] ret = Convertion.getBytes(name, serverEncoding);
        len += ret.length;
        len += 4;
        len += 4;
        len += 2;
        int i2 = 0;
        while (i2 < strctDesc.m_size) {
            len += TypeDescriptor.getPackSize(strctDesc.m_fieldsObj[i2]);
            ++i2;
        }
        return len;
    }

    public static int getPackClassSize(TypeDescriptor strctDesc) throws SQLException {
        int len = 0;
        len += 4;
        String name = strctDesc.m_sqlName.m_name;
        len += 2;
        String serverEncoding = strctDesc.getServerEncoding();
        byte[] ret = Convertion.getBytes(name, serverEncoding);
        len += ret.length;
        len += 4;
        len += 4;
        if (strctDesc.m_objId == 4) {
            len += 4;
            len += 4;
            len += 2;
        }
        return len;
    }

    public static void packClass(TypeDescriptor strctDesc, DmMsgSend msg) throws SQLException {
        msg.setInt(strctDesc.m_dTypeInfo.getDType());
        String name = strctDesc.m_sqlName.m_name;
        msg.setShort(name.length());
        String serverEncoding = strctDesc.getServerEncoding();
        msg.setString(name, serverEncoding);
        msg.setInt(strctDesc.m_objId);
        msg.setInt(strctDesc.m_objVersion);
        if (strctDesc.m_objId == 4) {
            msg.setInt(strctDesc.m_outerId);
            msg.setInt(strctDesc.m_outerVer);
            msg.setShort(strctDesc.m_subId);
        }
    }

    public static int packClass(TypeDescriptor strctDesc, DmMsgSend msg, int offset) throws SQLException {
        int offsetDes = offset;
        msg.setInt(strctDesc.m_dTypeInfo.getDType(), offsetDes);
        String name = strctDesc.m_sqlName.m_name;
        msg.setShort(name.length(), offsetDes += 4);
        offsetDes += 2;
        String serverEncoding = strctDesc.getServerEncoding();
        offsetDes += msg.setString(name, serverEncoding, offsetDes);
        msg.setInt(strctDesc.m_objId, offsetDes += name.length());
        msg.setInt(strctDesc.m_objVersion, offsetDes += 4);
        offsetDes += 4;
        if (strctDesc.m_objId == 4) {
            msg.setInt(strctDesc.m_outerId, offsetDes);
            msg.setInt(strctDesc.m_outerVer, offsetDes += 4);
            msg.setShort(strctDesc.m_subId, offsetDes += 4);
            return offsetDes += 2;
        }
        return offsetDes;
    }

    public int unpack(byte[] buf, int offset) throws SQLException {
        int offsetDes = offset;
        int dtype = Convertion.getInt(buf, offsetDes);
        offsetDes += 4;
        this.m_dTypeInfo.setDType(dtype);
        switch (dtype) {
            case 117: 
            case 122: {
                return this.unpackArray(buf, offsetDes);
            }
            case 119: {
                return this.unpackClass(buf, offsetDes);
            }
            case 121: {
                return this.unpackRecord(buf, offsetDes);
            }
        }
        int tmp = Convertion.getInt(buf, offsetDes);
        this.m_dTypeInfo.setPrec(tmp);
        tmp = Convertion.getInt(buf, offsetDes += 4);
        this.m_dTypeInfo.setScale(tmp);
        CommDesc commDesc = new CommDesc();
        commDesc.setDtypeInfo(this.m_dTypeInfo);
        commDesc.setLobDesc(this.m_lobDesc);
        this.accessor = BaseAccessor.getInstance(commDesc, this.m_conn, 0);
        return offsetDes += 4;
    }

    private int unpackArray(byte[] buf, int offset) throws SQLException {
        int offsetDes = offset;
        short tmpLen = Convertion.getShort(buf, offsetDes);
        String tmpName = Convertion.getString(buf, offsetDes += 2, tmpLen, this.getServerEncoding());
        this.m_sqlName.m_name = tmpName;
        this.m_sqlName.m_schId = Convertion.getInt(buf, offsetDes += tmpLen);
        this.m_sqlName.m_packId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objVersion = Convertion.getInt(buf, offsetDes += 4);
        offsetDes += 4;
        this.m_length = this.m_dTypeInfo.getDType() == 117 ? 0 : Convertion.getInt(buf, offsetDes);
        int descLen = 0;
        this.m_arrObj = new TypeDescriptor(this.m_conn);
        descLen = this.m_arrObj.unpack(buf, offsetDes += 4);
        return descLen;
    }

    private int unpackRecord(byte[] buf, int offset) throws SQLException {
        int offsetDes = offset;
        short tmpLen = Convertion.getShort(buf, offsetDes);
        String tmpName = Convertion.getString(buf, offsetDes += 2, tmpLen, this.getServerEncoding());
        this.m_sqlName.m_name = tmpName;
        this.m_sqlName.m_schId = Convertion.getInt(buf, offsetDes += tmpLen);
        this.m_sqlName.m_packId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objVersion = Convertion.getInt(buf, offsetDes += 4);
        this.m_size = Convertion.getShort(buf, offsetDes += 4);
        offsetDes += 2;
        this.m_fieldsObj = new TypeDescriptor[this.m_size];
        int i2 = 0;
        while (i2 < this.m_size) {
            this.m_fieldsObj[i2] = new TypeDescriptor(this.m_conn);
            offsetDes = this.m_fieldsObj[i2].unpack(buf, offsetDes);
            ++i2;
        }
        return offsetDes;
    }

    private int unpackClnt_nestTab(byte[] buf, int offsetDes) throws SQLException {
        this.m_maxCnt = Convertion.getInt(buf, offsetDes);
        this.m_arrObj = new TypeDescriptor(this.m_conn);
        return this.m_arrObj.unpack(buf, offsetDes += 4);
    }

    private int unpackClnt(byte[] buf, int offset) throws SQLException {
        int offsetDes = offset;
        this.m_outerId = Convertion.getInt(buf, offsetDes);
        this.m_outerVer = Convertion.getInt(buf, offsetDes += 4);
        this.m_subId = Convertion.getShort(buf, offsetDes += 4);
        this.m_cltnType = Convertion.getShort(buf, offsetDes += 2);
        offsetDes += 2;
        switch (this.m_cltnType) {
            case 3: {
                DBError.throwUnsupportedSQLException();
                break;
            }
            case 1: 
            case 2: {
                offsetDes = this.unpackClnt_nestTab(buf, offsetDes);
            }
        }
        return offsetDes;
    }

    private int unpackClass(byte[] buf, int offset) throws SQLException {
        int offsetDes = offset;
        short tmpLen = Convertion.getShort(buf, offsetDes);
        String tmpName = Convertion.getString(buf, offsetDes += 2, tmpLen, this.getServerEncoding());
        this.m_sqlName.m_name = tmpName;
        this.m_sqlName.m_schId = Convertion.getInt(buf, offsetDes += tmpLen);
        this.m_sqlName.m_packId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objId = Convertion.getInt(buf, offsetDes += 4);
        this.m_objVersion = Convertion.getInt(buf, offsetDes += 4);
        offsetDes += 4;
        if (this.m_objId == 4) {
            offsetDes = this.unpackClnt(buf, offsetDes);
        } else {
            this.m_size = Convertion.getShort(buf, offsetDes);
            offsetDes += 2;
            this.m_fieldsObj = new TypeDescriptor[this.m_size];
            int i2 = 0;
            while (i2 < this.m_size) {
                this.m_fieldsObj[i2] = new TypeDescriptor(this.m_conn);
                offsetDes = this.m_fieldsObj[i2].unpack(buf, offsetDes);
                ++i2;
            }
        }
        return offsetDes;
    }

    private int calcChkDescLen_array(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 4;
        return offset += this.calcChkDescLen(desc);
    }

    private int calcChkDescLen_record(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset += this.calcChkDescLen(desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int calcChkDescLen_class_normal(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset += this.calcChkDescLen(desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int calcChkDescLen_class_cnlt(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        offset += 2;
        offset += 4;
        switch (desc.getCltnType()) {
            case 3: {
                DBError.throwUnsupportedSQLException();
                break;
            }
            case 1: 
            case 2: {
                offset += this.calcChkDescLen(desc.m_arrObj);
            }
        }
        return offset;
    }

    private int calcChkDescLen_class(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        offset += 2;
        ++offset;
        offset = desc.m_objId == 4 ? (offset += this.calcChkDescLen_class_cnlt(desc)) : (offset += this.calcChkDescLen_class_normal(desc));
        return offset;
    }

    private int calcChkDescLen_buildin(TypeDescriptor desc) {
        int offset = 0;
        offset += 2;
        offset += 2;
        return offset += 2;
    }

    private int calcChkDescLen(TypeDescriptor desc) throws SQLException {
        int offset = 0;
        switch (desc.getDType()) {
            case 117: 
            case 122: {
                offset = this.calcChkDescLen_array(desc);
                break;
            }
            case 121: {
                offset = this.calcChkDescLen_record(desc);
                break;
            }
            case 119: {
                offset = this.calcChkDescLen_class(desc);
                break;
            }
            default: {
                offset = this.calcChkDescLen_buildin(desc);
            }
        }
        return offset;
    }

    private int makeChkDesc_array(int offset, TypeDescriptor desc) throws SQLException {
        Convertion.setShort(this.m_descBuf, offset, (short)117);
        Convertion.setInt(this.m_descBuf, offset += 2, desc.m_length);
        offset += 4;
        offset = this.makeChkDesc(offset, desc);
        return offset;
    }

    private int makeChkDesc_record(int offset, TypeDescriptor desc) throws SQLException {
        Convertion.setShort(this.m_descBuf, offset, (short)121);
        Convertion.setShort(this.m_descBuf, offset += 2, (short)desc.m_size);
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset = this.makeChkDesc(offset, desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int makeChkDesc_buildin(int offset, TypeDescriptor desc) {
        short dtype = (short)desc.getDType();
        short prec = 0;
        short scale = 0;
        if (dtype != 12) {
            prec = (short)desc.getDTypeInfo().getPrec();
            scale = (short)desc.getDTypeInfo().getScale();
        }
        Convertion.setShort(this.m_descBuf, offset, dtype);
        Convertion.setShort(this.m_descBuf, offset += 2, prec);
        Convertion.setShort(this.m_descBuf, offset += 2, scale);
        return offset += 2;
    }

    private int makeChkDesc_class_normal(int offset, TypeDescriptor desc) throws SQLException {
        Convertion.setShort(this.m_descBuf, offset, (short)desc.m_size);
        offset += 2;
        int i2 = 0;
        while (i2 < desc.m_size) {
            offset = this.makeChkDesc(offset, desc.m_fieldsObj[i2]);
            ++i2;
        }
        return offset;
    }

    private int makeChkDesc_class_clnt(int offset, TypeDescriptor desc) throws SQLException {
        Convertion.setShort(this.m_descBuf, offset, (short)desc.m_cltnType);
        Convertion.setInt(this.m_descBuf, offset += 2, desc.getMaxCnt());
        offset += 4;
        switch (desc.m_cltnType) {
            case 3: {
                DBError.throwUnsupportedSQLException();
                break;
            }
            case 1: 
            case 2: {
                offset = this.makeChkDesc(offset, desc.m_arrObj);
            }
        }
        return offset;
    }

    private int makeChkDesc_class(int offset, TypeDescriptor desc) throws SQLException {
        Convertion.setShort(this.m_descBuf, offset, (short)119);
        offset += 2;
        boolean isClnt = false;
        if (desc.m_objId == 4) {
            isClnt = true;
        }
        if (isClnt) {
            Convertion.setByte(this.m_descBuf, offset, (byte)1);
        } else {
            Convertion.setByte(this.m_descBuf, offset, (byte)0);
        }
        ++offset;
        offset = isClnt ? this.makeChkDesc_class_clnt(offset, desc) : this.makeChkDesc_class_normal(offset, desc);
        return offset;
    }

    private int makeChkDesc(int offset, TypeDescriptor subDesc) throws SQLException {
        switch (subDesc.getDType()) {
            case 117: 
            case 122: {
                offset = this.makeChkDesc_array(offset, subDesc);
                break;
            }
            case 121: {
                offset = this.makeChkDesc_record(offset, subDesc);
                break;
            }
            case 119: {
                offset = this.makeChkDesc_class(offset, subDesc);
                break;
            }
            default: {
                offset = this.makeChkDesc_buildin(offset, subDesc);
            }
        }
        return offset;
    }

    public byte[] getClassDescChkInfo() throws SQLException {
        if (this.m_descBuf != null) {
            return this.m_descBuf;
        }
        int len = this.calcChkDescLen(this);
        this.m_descBuf = new byte[len];
        this.makeChkDesc(0, this);
        return this.m_descBuf;
    }
}

