/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression.operators.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;

public class NamedExpressionList
implements ItemsList {
    private List<Expression> expressions;
    private List<String> names;

    public NamedExpressionList() {
    }

    public NamedExpressionList(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public NamedExpressionList(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public void setNames(List<String> list) {
        this.names = list;
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("(");
        for (int i2 = 0; i2 < this.expressions.size(); ++i2) {
            if (i2 > 0) {
                ret.append(" ");
            }
            if (!this.names.get(i2).equals("")) {
                ret.append(this.names.get(i2)).append(" ").append(this.expressions.get(i2));
                continue;
            }
            ret.append(this.expressions.get(i2));
        }
        ret.append(")");
        return ret.toString();
    }

    public NamedExpressionList withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public NamedExpressionList withNames(List<String> names) {
        this.setNames(names);
        return this;
    }

    public NamedExpressionList addExpressions(Expression ... expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, expressions);
        return this.withExpressions(collection);
    }

    public NamedExpressionList addExpressions(Collection<? extends Expression> expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        collection.addAll(expressions);
        return this.withExpressions(collection);
    }

    public NamedExpressionList addNames(String ... names) {
        List collection = Optional.ofNullable(this.getNames()).orElseGet(ArrayList::new);
        Collections.addAll(collection, names);
        return this.withNames(collection);
    }

    public NamedExpressionList addNames(Collection<String> names) {
        List collection = Optional.ofNullable(this.getNames()).orElseGet(ArrayList::new);
        collection.addAll(names);
        return this.withNames(collection);
    }
}

