/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.EnumSet;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationUtil;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class AlterValidator
extends AbstractValidator<Alter> {
    @Override
    public void validate(Alter alter) {
        this.validateFeature(Feature.alterTable);
        this.validateOptionalFromItem(alter.getTable());
        alter.getAlterExpressions().forEach(e2 -> this.validate(alter, (AlterExpression)e2));
    }

    public void validate(Alter alter, AlterExpression e2) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateOptionalColumnName(c2, e2.getColumnOldName());
            this.validateOptionalColumnName(c2, e2.getColumnName());
            if (e2.getColumnDropNotNullList() != null) {
                this.validateOptionalColumnNames(c2, ValidationUtil.map(e2.getColumnDropNotNullList(), AlterExpression.ColumnDropNotNull::getColumnName), new NamedObject[0]);
            }
            if (e2.getColDataTypeList() != null) {
                boolean validateForExist = !EnumSet.of(AlterOperation.ADD).contains((Object)e2.getOperation());
                this.validateOptionalColumnNames(c2, ValidationUtil.map(e2.getColDataTypeList(), ColumnDefinition::getColumnName), validateForExist, NamedObject.table);
            }
            this.validateOptionalName(c2, NamedObject.constraint, e2.getConstraintName(), new NamedObject[0]);
            if (e2.getPkColumns() != null) {
                this.validateOptionalColumnNames(c2, e2.getPkColumns(), new NamedObject[0]);
            }
            if (e2.getFkColumns() != null) {
                this.validateName(c2, NamedObject.table, e2.getFkSourceTable());
                this.validateOptionalColumnNames(c2, e2.getFkColumns(), new NamedObject[0]);
                this.validateOptionalColumnNames(c2, e2.getFkSourceColumns(), new NamedObject[0]);
            }
            if (e2.getUk()) {
                this.validateName(c2, NamedObject.uniqueConstraint, e2.getUkName());
                this.validateOptionalColumnNames(c2, e2.getUkColumns(), NamedObject.uniqueConstraint);
            }
            if (e2.getIndex() == null) continue;
            this.validateName(c2, NamedObject.index, e2.getIndex().getName());
            if (e2.getIndex().getColumns() == null) continue;
            this.validateOptionalColumnNames(c2, e2.getIndex().getColumnsNames(), NamedObject.index);
        }
    }
}

