/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.create.view.ForceOption;
import net.sf.jsqlparser.statement.create.view.TemporaryOption;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class CreateViewValidator
extends AbstractValidator<CreateView> {
    @Override
    public void validate(CreateView createView) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.createView);
            this.validateFeature(c2, createView.isOrReplace(), Feature.createOrReplaceView);
            this.validateFeature(c2, !ForceOption.NONE.equals((Object)createView.getForce()), Feature.createViewForce);
            this.validateFeature(c2, !TemporaryOption.NONE.equals((Object)createView.getTemporary()), Feature.createViewTemporary);
            this.validateFeature(c2, createView.isMaterialized(), Feature.createViewMaterialized);
            this.validateName(c2, NamedObject.view, createView.getView().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        SelectValidator v2 = this.getValidator(SelectValidator.class);
        Select select = createView.getSelect();
        if (this.isNotEmpty(select.getWithItemsList())) {
            select.getWithItemsList().forEach(wi -> wi.accept(v2));
        }
        select.getSelectBody().accept(v2);
    }
}

