/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class InsertValidator
extends AbstractValidator<Insert> {
    @Override
    public void validate(Insert insert) {
        ExpressionValidator v2;
        for (ValidationCapability c3 : this.getCapabilities()) {
            this.validateFeature(c3, Feature.insert);
            this.validateOptionalFeature(c3, insert.getItemsList(), Feature.insertValues);
            this.validateOptionalFeature(c3, (Object)insert.getModifierPriority(), Feature.insertModifierPriority);
            this.validateFeature(c3, insert.isModifierIgnore(), Feature.insertModifierIgnore);
            this.validateOptionalFeature(c3, insert.getSelect(), Feature.insertFromSelect);
            this.validateFeature(c3, insert.isUseSet(), Feature.insertUseSet);
            this.validateFeature(c3, insert.isUseDuplicate(), Feature.insertUseDuplicateKeyUpdate);
            this.validateFeature(c3, insert.isReturningAllColumns(), Feature.insertReturningAll);
            this.validateOptionalFeature(c3, insert.getReturningExpressionList(), Feature.insertReturningExpressionList);
        }
        this.validateOptionalFromItem(insert.getTable());
        this.validateOptionalExpressions(insert.getColumns());
        this.validateOptionalItemsList(insert.getItemsList());
        if (insert.getSelect() != null) {
            insert.getSelect().accept(this.getValidator(StatementValidator.class));
        }
        if (insert.isUseSet()) {
            v2 = this.getValidator(ExpressionValidator.class);
            insert.getSetColumns().forEach(c2 -> c2.accept(v2));
            insert.getSetExpressionList().forEach(c2 -> c2.accept(v2));
        }
        if (insert.isUseDuplicate()) {
            v2 = this.getValidator(ExpressionValidator.class);
            insert.getDuplicateUpdateColumns().forEach(c2 -> c2.accept(v2));
            insert.getDuplicateUpdateExpressionList().forEach(c2 -> c2.accept(v2));
        }
        if (this.isNotEmpty(insert.getReturningExpressionList())) {
            v2 = this.getValidator(ExpressionValidator.class);
            insert.getReturningExpressionList().forEach(c2 -> c2.getExpression().accept(v2));
        }
    }
}

