/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.img.gif.AnimatedGifEncoder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class GifCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = 7091627304326538464L;
    private int quality = 10;
    private int repeat = 0;
    private int minColor = 0;
    private int maxColor = 255;

    public GifCaptcha(int width, int height) {
        this(width, height, 5);
    }

    public GifCaptcha(int width, int height, int codeCount) {
        super(width, height, codeCount, 10);
    }

    public GifCaptcha setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.quality = quality;
        return this;
    }

    public GifCaptcha setRepeat(int repeat) {
        if (repeat >= 0) {
            this.repeat = repeat;
        }
        return this;
    }

    public GifCaptcha setMaxColor(int maxColor) {
        this.maxColor = maxColor;
        return this;
    }

    public GifCaptcha setMinColor(int minColor) {
        this.minColor = minColor;
        return this;
    }

    @Override
    public void createCode() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AnimatedGifEncoder gifEncoder = new AnimatedGifEncoder();
        gifEncoder.start(out);
        gifEncoder.setQuality(this.quality);
        int delay = 100;
        gifEncoder.setDelay(delay);
        gifEncoder.setRepeat(this.repeat);
        char[] chars = this.code.toCharArray();
        Color[] fontColor = new Color[chars.length];
        for (int i2 = 0; i2 < chars.length; ++i2) {
            fontColor[i2] = this.getRandomColor(this.minColor, this.maxColor);
            BufferedImage frame = this.graphicsImage(chars, fontColor, chars, i2);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }

    @Override
    protected Image createImage(String code) {
        return null;
    }

    private BufferedImage graphicsImage(char[] chars, Color[] fontColor, char[] words, int flag) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(ObjectUtil.defaultIfNull(this.background, Color.WHITE));
        g2d.fillRect(0, 0, this.width, this.height);
        float y2 = (this.height >> 1) + (this.font.getSize() >> 1);
        float m3 = 1.0f * (float)(this.width - chars.length * this.font.getSize()) / (float)chars.length;
        float x2 = Math.max(m3 / 2.0f, 2.0f);
        g2d.setFont(this.font);
        if (null != this.textAlpha) {
            g2d.setComposite(this.textAlpha);
        }
        for (int i2 = 0; i2 < chars.length; ++i2) {
            AlphaComposite ac2 = AlphaComposite.getInstance(3, this.getAlpha(chars.length, flag, i2));
            g2d.setComposite(ac2);
            g2d.setColor(fontColor[i2]);
            g2d.drawOval(RandomUtil.randomInt(this.width), RandomUtil.randomInt(this.height), RandomUtil.randomInt(5, 30), 5 + RandomUtil.randomInt(5, 30));
            g2d.drawString(words[i2] + "", x2 + ((float)this.font.getSize() + m3) * (float)i2, y2);
        }
        g2d.dispose();
        return image;
    }

    private float getAlpha(int v2, int i2, int j2) {
        int num = i2 + j2;
        float r2 = 1.0f / (float)v2;
        float s2 = (float)(v2 + 1) * r2;
        return num > v2 ? (float)num * r2 - s2 : (float)num * r2;
    }

    private Color getRandomColor(int min2, int max) {
        if (min2 > 255) {
            min2 = 255;
        }
        if (max > 255) {
            max = 255;
        }
        if (min2 < 0) {
            min2 = 0;
        }
        if (max < 0) {
            max = 0;
        }
        if (min2 > max) {
            min2 = 0;
            max = 255;
        }
        return new Color(RandomUtil.randomInt(min2, max), RandomUtil.randomInt(min2, max), RandomUtil.randomInt(min2, max));
    }
}

