/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.sf.jsqlparser.statement.ReferentialAction;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.alter.ConstraintState;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class AlterExpression {
    private AlterOperation operation;
    private String optionalSpecifier;
    private String newTableName;
    private String columnName;
    private String columnOldName;
    private List<ColumnDataType> colDataTypeList;
    private List<ColumnDropNotNull> columnDropNotNullList;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;
    private Index index = null;
    private String constraintName;
    private boolean usingIfExists;
    private Set<ReferentialAction> referentialActions = new LinkedHashSet<ReferentialAction>(2);
    private List<String> fkColumns;
    private String fkSourceSchema;
    private String fkSourceTable;
    private List<String> fkSourceColumns;
    private boolean uk;
    private boolean useEqual;
    private List<ConstraintState> constraints;
    private List<String> parameters;
    private String commentText;
    private boolean hasColumn = false;

    public boolean hasColumn() {
        return this.hasColumn;
    }

    public void hasColumn(boolean hasColumn) {
        this.hasColumn = hasColumn;
    }

    public String getFkSourceSchema() {
        return this.fkSourceSchema;
    }

    public void setFkSourceSchema(String fkSourceSchema) {
        this.fkSourceSchema = fkSourceSchema;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public AlterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterOperation operation) {
        this.operation = operation;
    }

    public String getOptionalSpecifier() {
        return this.optionalSpecifier;
    }

    public void setOptionalSpecifier(String optionalSpecifier) {
        this.optionalSpecifier = optionalSpecifier;
    }

    public void setReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action) {
        this.setReferentialAction(type, action, true);
    }

    public AlterExpression withReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action) {
        this.setReferentialAction(type, action);
        return this;
    }

    public void removeReferentialAction(ReferentialAction.Type type) {
        this.setReferentialAction(type, null, false);
    }

    public ReferentialAction getReferentialAction(ReferentialAction.Type type) {
        return this.referentialActions.stream().filter(ra -> type.equals((Object)ra.getType())).findFirst().orElse(null);
    }

    private void setReferentialAction(ReferentialAction.Type type, ReferentialAction.Action action, boolean set) {
        ReferentialAction found = this.getReferentialAction(type);
        if (set) {
            if (found == null) {
                this.referentialActions.add(new ReferentialAction(type, action));
            } else {
                found.setAction(action);
            }
        } else if (found != null) {
            this.referentialActions.remove(found);
        }
    }

    @Deprecated
    public boolean isOnDeleteCascade() {
        ReferentialAction found = this.getReferentialAction(ReferentialAction.Type.DELETE);
        return found != null && ReferentialAction.Action.CASCADE.equals((Object)found.getAction());
    }

    @Deprecated
    public void setOnDeleteCascade(boolean onDeleteCascade) {
        this.setReferentialAction(ReferentialAction.Type.DELETE, ReferentialAction.Action.CASCADE, onDeleteCascade);
    }

    @Deprecated
    public boolean isOnDeleteRestrict() {
        ReferentialAction found = this.getReferentialAction(ReferentialAction.Type.DELETE);
        return found != null && ReferentialAction.Action.RESTRICT.equals((Object)found.getAction());
    }

    @Deprecated
    public void setOnDeleteRestrict(boolean onDeleteRestrict) {
        this.setReferentialAction(ReferentialAction.Type.DELETE, ReferentialAction.Action.RESTRICT, onDeleteRestrict);
    }

    @Deprecated
    public boolean isOnDeleteSetNull() {
        ReferentialAction found = this.getReferentialAction(ReferentialAction.Type.DELETE);
        return found != null && ReferentialAction.Action.SET_NULL.equals((Object)found.getAction());
    }

    @Deprecated
    public void setOnDeleteSetNull(boolean onDeleteSetNull) {
        this.setReferentialAction(ReferentialAction.Type.DELETE, ReferentialAction.Action.SET_NULL, onDeleteSetNull);
    }

    public List<String> getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(List<String> fkColumns) {
        this.fkColumns = fkColumns;
    }

    public String getFkSourceTable() {
        return this.fkSourceTable;
    }

    public void setFkSourceTable(String fkSourceTable) {
        this.fkSourceTable = fkSourceTable;
    }

    public List<ColumnDataType> getColDataTypeList() {
        return this.colDataTypeList;
    }

    public void addColDataType(String columnName, ColDataType colDataType) {
        this.addColDataType(new ColumnDataType(columnName, false, colDataType, null));
    }

    public void addColDataType(ColumnDataType columnDataType) {
        if (this.colDataTypeList == null) {
            this.colDataTypeList = new ArrayList<ColumnDataType>();
        }
        this.colDataTypeList.add(columnDataType);
    }

    public void addColDropNotNull(ColumnDropNotNull columnDropNotNull) {
        if (this.columnDropNotNullList == null) {
            this.columnDropNotNullList = new ArrayList<ColumnDropNotNull>();
        }
        this.columnDropNotNullList.add(columnDropNotNull);
    }

    public List<String> getFkSourceColumns() {
        return this.fkSourceColumns;
    }

    public void setFkSourceColumns(List<String> fkSourceColumns) {
        this.fkSourceColumns = fkSourceColumns;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Deprecated
    public String getColOldName() {
        return this.getColumnOldName();
    }

    @Deprecated
    public void setColOldName(String columnOldName) {
        this.setColumnOldName(columnOldName);
    }

    public String getColumnOldName() {
        return this.columnOldName;
    }

    public void setColumnOldName(String columnOldName) {
        this.columnOldName = columnOldName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public boolean isUsingIfExists() {
        return this.usingIfExists;
    }

    public void setUsingIfExists(boolean usingIfExists) {
        this.usingIfExists = usingIfExists;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> ukColumns) {
        this.ukColumns = ukColumns;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String ukName) {
        this.ukName = ukName;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public List<ConstraintState> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ConstraintState> constraints) {
        this.constraints = constraints;
    }

    public List<ColumnDropNotNull> getColumnDropNotNullList() {
        return this.columnDropNotNullList;
    }

    public void addParameters(String ... params) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.addAll(Arrays.asList(params));
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean getUseEqual() {
        return this.useEqual;
    }

    public void setUseEqual(boolean useEqual) {
        this.useEqual = useEqual;
    }

    public boolean getUk() {
        return this.uk;
    }

    public void setUk(boolean uk) {
        this.uk = uk;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        if (this.operation == AlterOperation.UNSPECIFIC) {
            b2.append(this.optionalSpecifier);
        } else if (this.operation == AlterOperation.RENAME_TABLE) {
            b2.append("RENAME TO ").append(this.newTableName);
        } else if (this.operation == AlterOperation.DROP_PRIMARY_KEY) {
            b2.append("DROP PRIMARY KEY ");
        } else if (this.operation == AlterOperation.DROP_UNIQUE) {
            b2.append("DROP UNIQUE (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.operation == AlterOperation.DROP_FOREIGN_KEY) {
            b2.append("DROP FOREIGN KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.operation == AlterOperation.DROP && this.columnName == null && this.pkColumns != null && this.pkColumns.size() > 0) {
            b2.append("DROP (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else {
            b2.append((Object)this.operation).append(" ");
            if (this.commentText != null) {
                if (this.columnName != null) {
                    b2.append(this.columnName).append(" COMMENT ");
                }
                b2.append(this.commentText);
            } else if (this.columnName != null) {
                if (this.hasColumn) {
                    b2.append("COLUMN ");
                }
                if (this.operation == AlterOperation.RENAME) {
                    b2.append(this.columnOldName).append(" TO ");
                }
                b2.append(this.columnName);
            } else if (this.getColDataTypeList() != null) {
                if (this.operation == AlterOperation.CHANGE) {
                    if (this.optionalSpecifier != null) {
                        b2.append(this.optionalSpecifier).append(" ");
                    }
                    b2.append(this.columnOldName).append(" ");
                } else if (this.colDataTypeList.size() > 1) {
                    b2.append("(");
                } else if (this.hasColumn) {
                    b2.append("COLUMN ");
                }
                b2.append(PlainSelect.getStringList(this.colDataTypeList));
                if (this.colDataTypeList.size() > 1) {
                    b2.append(")");
                }
            } else if (this.getColumnDropNotNullList() != null) {
                if (this.operation == AlterOperation.CHANGE) {
                    if (this.optionalSpecifier != null) {
                        b2.append(this.optionalSpecifier).append(" ");
                    }
                    b2.append(this.columnOldName).append(" ");
                } else if (this.columnDropNotNullList.size() > 1) {
                    b2.append("(");
                } else {
                    b2.append("COLUMN ");
                }
                b2.append(PlainSelect.getStringList(this.columnDropNotNullList));
                if (this.columnDropNotNullList.size() > 1) {
                    b2.append(")");
                }
            } else if (this.constraintName != null) {
                b2.append("CONSTRAINT ");
                if (this.usingIfExists) {
                    b2.append("IF EXISTS ");
                }
                b2.append(this.constraintName);
            } else if (this.pkColumns != null) {
                b2.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
            } else if (this.ukColumns != null) {
                b2.append("UNIQUE");
                if (this.ukName != null) {
                    if (this.getUk()) {
                        b2.append(" KEY ");
                    } else {
                        b2.append(" INDEX ");
                    }
                    b2.append(this.ukName);
                }
                b2.append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
            } else if (this.fkColumns != null) {
                b2.append("FOREIGN KEY (").append(PlainSelect.getStringList(this.fkColumns)).append(") REFERENCES ").append(this.fkSourceSchema != null && this.fkSourceSchema.trim().length() > 0 ? this.fkSourceSchema + "." : "").append(this.fkSourceTable).append(" (").append(PlainSelect.getStringList(this.fkSourceColumns)).append(")");
                this.referentialActions.forEach(b2::append);
            } else if (this.index != null) {
                b2.append(this.index);
            }
            if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
                b2.append(' ').append(PlainSelect.getStringList(this.constraints, false, false));
            }
            if (this.getUseEqual()) {
                b2.append('=');
            }
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            b2.append(' ').append(PlainSelect.getStringList(this.parameters, false, false));
        }
        return b2.toString();
    }

    public AlterExpression withOperation(AlterOperation operation) {
        this.setOperation(operation);
        return this;
    }

    public AlterExpression withOptionalSpecifier(String optionalSpecifier) {
        this.setOptionalSpecifier(optionalSpecifier);
        return this;
    }

    public AlterExpression withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public AlterExpression withPkColumns(List<String> pkColumns) {
        this.setPkColumns(pkColumns);
        return this;
    }

    public AlterExpression withUkColumns(List<String> ukColumns) {
        this.setUkColumns(ukColumns);
        return this;
    }

    public AlterExpression withUkName(String ukName) {
        this.setUkName(ukName);
        return this;
    }

    public AlterExpression withIndex(Index index) {
        this.setIndex(index);
        return this;
    }

    public AlterExpression withConstraintName(String constraintName) {
        this.setConstraintName(constraintName);
        return this;
    }

    public AlterExpression withUsingIfExists(boolean usingIfExists) {
        this.setUsingIfExists(usingIfExists);
        return this;
    }

    public AlterExpression withOnDeleteRestrict(boolean onDeleteRestrict) {
        this.setOnDeleteRestrict(onDeleteRestrict);
        return this;
    }

    public AlterExpression withOnDeleteSetNull(boolean onDeleteSetNull) {
        this.setOnDeleteSetNull(onDeleteSetNull);
        return this;
    }

    public AlterExpression withOnDeleteCascade(boolean onDeleteCascade) {
        this.setOnDeleteCascade(onDeleteCascade);
        return this;
    }

    public AlterExpression withFkColumns(List<String> fkColumns) {
        this.setFkColumns(fkColumns);
        return this;
    }

    public AlterExpression withFkSourceSchema(String fkSourceSchema) {
        this.setFkSourceTable(fkSourceSchema);
        return this;
    }

    public AlterExpression withFkSourceTable(String fkSourceTable) {
        this.setFkSourceTable(fkSourceTable);
        return this;
    }

    public AlterExpression withFkSourceColumns(List<String> fkSourceColumns) {
        this.setFkSourceColumns(fkSourceColumns);
        return this;
    }

    public AlterExpression withUk(boolean uk) {
        this.setUk(uk);
        return this;
    }

    public AlterExpression withUseEqual(boolean useEqual) {
        this.setUseEqual(useEqual);
        return this;
    }

    public AlterExpression withConstraints(List<ConstraintState> constraints) {
        this.setConstraints(constraints);
        return this;
    }

    public AlterExpression withCommentText(String commentText) {
        this.setCommentText(commentText);
        return this;
    }

    public AlterExpression withColumnOldName(String columnOldName) {
        this.setColumnOldName(columnOldName);
        return this;
    }

    public AlterExpression addPkColumns(String ... pkColumns) {
        List collection = Optional.ofNullable(this.getPkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, pkColumns);
        return this.withPkColumns(collection);
    }

    public AlterExpression addPkColumns(Collection<String> pkColumns) {
        List collection = Optional.ofNullable(this.getPkColumns()).orElseGet(ArrayList::new);
        collection.addAll(pkColumns);
        return this.withPkColumns(collection);
    }

    public AlterExpression addUkColumns(String ... ukColumns) {
        List collection = Optional.ofNullable(this.getUkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, ukColumns);
        return this.withUkColumns(collection);
    }

    public AlterExpression addUkColumns(Collection<String> ukColumns) {
        List collection = Optional.ofNullable(this.getUkColumns()).orElseGet(ArrayList::new);
        collection.addAll(ukColumns);
        return this.withUkColumns(collection);
    }

    public AlterExpression addFkColumns(String ... fkColumns) {
        List collection = Optional.ofNullable(this.getFkColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, fkColumns);
        return this.withFkColumns(collection);
    }

    public AlterExpression addFkColumns(Collection<String> fkColumns) {
        List collection = Optional.ofNullable(this.getFkColumns()).orElseGet(ArrayList::new);
        collection.addAll(fkColumns);
        return this.withFkColumns(collection);
    }

    public AlterExpression addFkSourceColumns(String ... fkSourceColumns) {
        List collection = Optional.ofNullable(this.getFkSourceColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, fkSourceColumns);
        return this.withFkSourceColumns(collection);
    }

    public AlterExpression addFkSourceColumns(Collection<String> fkSourceColumns) {
        List collection = Optional.ofNullable(this.getFkSourceColumns()).orElseGet(ArrayList::new);
        collection.addAll(fkSourceColumns);
        return this.withFkSourceColumns(collection);
    }

    public AlterExpression addConstraints(ConstraintState ... constraints) {
        List collection = Optional.ofNullable(this.getConstraints()).orElseGet(ArrayList::new);
        Collections.addAll(collection, constraints);
        return this.withConstraints(collection);
    }

    public AlterExpression addConstraints(Collection<? extends ConstraintState> constraints) {
        List collection = Optional.ofNullable(this.getConstraints()).orElseGet(ArrayList::new);
        collection.addAll(constraints);
        return this.withConstraints(collection);
    }

    public static final class ColumnDropNotNull {
        private final String columnName;
        private final boolean withNot;

        public ColumnDropNotNull(String columnName) {
            this(columnName, false);
        }

        public ColumnDropNotNull(String columnName, boolean withNot) {
            this.columnName = columnName;
            this.withNot = withNot;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isWithNot() {
            return this.withNot;
        }

        public String toString() {
            return this.columnName + " DROP" + (this.withNot ? " NOT " : " ") + "NULL";
        }
    }

    public static final class ColumnDataType
    extends ColumnDefinition {
        private final boolean withType;

        public ColumnDataType(boolean withType) {
            this.withType = withType;
        }

        public ColumnDataType(String columnName, boolean withType, ColDataType colDataType, List<String> columnSpecs) {
            super(columnName, colDataType, columnSpecs);
            this.withType = withType;
        }

        @Override
        public String toString() {
            return this.getColumnName() + (this.withType ? " TYPE " : " ") + this.toStringDataTypeAndSpec();
        }

        @Override
        public ColumnDataType withColDataType(ColDataType colDataType) {
            return (ColumnDataType)super.withColDataType(colDataType);
        }

        @Override
        public ColumnDataType withColumnName(String columnName) {
            return (ColumnDataType)super.withColumnName(columnName);
        }

        @Override
        public ColumnDataType addColumnSpecs(String ... columnSpecs) {
            return (ColumnDataType)super.addColumnSpecs(columnSpecs);
        }

        @Override
        public ColumnDataType addColumnSpecs(Collection<String> columnSpecs) {
            return (ColumnDataType)super.addColumnSpecs(columnSpecs);
        }

        @Override
        public ColumnDataType withColumnSpecs(List<String> columnSpecs) {
            return (ColumnDataType)super.withColumnSpecs(columnSpecs);
        }
    }
}

