/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScans;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    @Deprecated
    public void setResourceLoader(ResourceLoader resourceLoader) {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(importingClassMetadata, mapperScanAttrs, registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, 0));
        }
    }

    void registerBeanDefinitions(AnnotationMetadata annoMeta, AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry, String beanName) {
        String defaultScope;
        String lazyInitialization;
        String sqlSessionFactoryRef;
        String sqlSessionTemplateRef;
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
        Class annotationClass = annoAttrs.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            builder.addPropertyValue("annotationClass", (Object)annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            builder.addPropertyValue("markerInterface", (Object)markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            builder.addPropertyValue("nameGenerator", BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            builder.addPropertyValue("mapperFactoryBeanClass", (Object)mapperFactoryBeanClass);
        }
        if (StringUtils.hasText((String)(sqlSessionTemplateRef = annoAttrs.getString("sqlSessionTemplateRef")))) {
            builder.addPropertyValue("sqlSessionTemplateBeanName", (Object)annoAttrs.getString("sqlSessionTemplateRef"));
        }
        if (StringUtils.hasText((String)(sqlSessionFactoryRef = annoAttrs.getString("sqlSessionFactoryRef")))) {
            builder.addPropertyValue("sqlSessionFactoryBeanName", (Object)annoAttrs.getString("sqlSessionFactoryRef"));
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("value")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getClassArray("basePackageClasses")).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        if (basePackages.isEmpty()) {
            basePackages.add(MapperScannerRegistrar.getDefaultBasePackage(annoMeta));
        }
        if (StringUtils.hasText((String)(lazyInitialization = annoAttrs.getString("lazyInitialization")))) {
            builder.addPropertyValue("lazyInitialization", (Object)lazyInitialization);
        }
        if (!"".equals(defaultScope = annoAttrs.getString("defaultScope"))) {
            builder.addPropertyValue("defaultScope", (Object)defaultScope);
        }
        builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(basePackages));
        builder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata, int index) {
        return importingClassMetadata.getClassName() + "#" + MapperScannerRegistrar.class.getSimpleName() + "#" + index;
    }

    private static String getDefaultBasePackage(AnnotationMetadata importingClassMetadata) {
        return ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
    }

    static class RepeatingRegistrar
    extends MapperScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                AnnotationAttributes[] annotations = mapperScansAttrs.getAnnotationArray("value");
                for (int i2 = 0; i2 < annotations.length; ++i2) {
                    this.registerBeanDefinitions(importingClassMetadata, annotations[i2], registry, MapperScannerRegistrar.generateBaseBeanName(importingClassMetadata, i2));
                }
            }
        }
    }
}

