/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

public class PercentCodec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public static PercentCodec of(PercentCodec codec) {
        return new PercentCodec((BitSet)codec.safeCharacters.clone());
    }

    public static PercentCodec of(CharSequence chars) {
        Assert.notNull(chars, "chars must not be null", new Object[0]);
        PercentCodec codec = new PercentCodec();
        int length = chars.length();
        for (int i2 = 0; i2 < length; ++i2) {
            codec.addSafe(chars.charAt(i2));
        }
        return codec;
    }

    public PercentCodec() {
        this(new BitSet(256));
    }

    public PercentCodec(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public PercentCodec addSafe(char c2) {
        this.safeCharacters.set(c2);
        return this;
    }

    public PercentCodec removeSafe(char c2) {
        this.safeCharacters.clear(c2);
        return this;
    }

    public PercentCodec or(PercentCodec codec) {
        this.safeCharacters.or(codec.safeCharacters);
        return this;
    }

    public PercentCodec orNew(PercentCodec codec) {
        return PercentCodec.of(this).or(codec);
    }

    public PercentCodec setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
        return this;
    }

    public String encode(CharSequence path, Charset charset, char ... customSafeChar) {
        if (null == charset || StrUtil.isEmpty(path)) {
            return StrUtil.str(path);
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i2 = 0; i2 < path.length(); ++i2) {
            byte[] ba;
            char c2 = path.charAt(i2);
            if (this.safeCharacters.get(c2) || ArrayUtil.contains(customSafeChar, c2)) {
                rewrittenPath.append(c2);
                continue;
            }
            if (this.encodeSpaceAsPlus && c2 == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c2);
                writer.flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                HexUtil.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

