/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.map.SafeConcurrentHashMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 7997886765361607470L;
    private static final Boolean PRESENT = true;
    private final SafeConcurrentHashMap<E, Boolean> map;

    public ConcurrentHashSet() {
        this.map = new SafeConcurrentHashMap();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new SafeConcurrentHashMap(initialCapacity);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.map = new SafeConcurrentHashMap(initialCapacity, loadFactor);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new SafeConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentHashSet(Iterable<E> iter) {
        if (iter instanceof Collection) {
            Collection collection = (Collection)iter;
            this.map = new SafeConcurrentHashMap((int)((float)collection.size() / 0.75f));
            this.addAll(collection);
        } else {
            this.map = new SafeConcurrentHashMap();
            for (E e2 : iter) {
                this.add(e2);
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.map.containsKey(o2);
    }

    @Override
    public boolean add(E e2) {
        return this.map.put(e2, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o2) {
        return PRESENT.equals(this.map.remove(o2));
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

