/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.finder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.finder.TextFinder;

public class StrFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final CharSequence strToFind;
    private final boolean caseInsensitive;

    public StrFinder(CharSequence strToFind, boolean caseInsensitive) {
        Assert.notEmpty(strToFind);
        this.strToFind = strToFind;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int subLen = this.strToFind.length();
        if (from < 0) {
            from = 0;
        }
        int endLimit = this.getValidEndIndex();
        if (this.negative) {
            for (int i2 = from; i2 > endLimit; --i2) {
                if (!CharSequenceUtil.isSubEquals(this.text, i2, this.strToFind, 0, subLen, this.caseInsensitive)) continue;
                return i2;
            }
        } else {
            endLimit = endLimit - subLen + 1;
            for (int i3 = from; i3 < endLimit; ++i3) {
                if (!CharSequenceUtil.isSubEquals(this.text, i3, this.strToFind, 0, subLen, this.caseInsensitive)) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + this.strToFind.length();
    }
}

