/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import java.time.Year;
import java.util.Calendar;
import java.util.TimeZone;

public class PatternMatcher {
    private final PartMatcher[] matchers;

    public PatternMatcher(PartMatcher secondMatcher, PartMatcher minuteMatcher, PartMatcher hourMatcher, PartMatcher dayOfMonthMatcher, PartMatcher monthMatcher, PartMatcher dayOfWeekMatcher, PartMatcher yearMatcher) {
        this.matchers = new PartMatcher[]{secondMatcher, minuteMatcher, hourMatcher, dayOfMonthMatcher, monthMatcher, dayOfWeekMatcher, yearMatcher};
    }

    public PartMatcher get(Part part) {
        return this.matchers[part.ordinal()];
    }

    public boolean match(int[] fields) {
        return this.match(fields[0], fields[1], fields[2], fields[3], fields[4], fields[5], fields[6]);
    }

    public boolean matchWeek(int dayOfWeekValue) {
        return this.matchers[5].match(dayOfWeekValue);
    }

    private boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        return (second < 0 || this.matchers[0].match(second)) && this.matchers[1].match(minute) && this.matchers[2].match(hour) && PatternMatcher.matchDayOfMonth(this.matchers[3], dayOfMonth, month, Year.isLeap(year)) && this.matchers[4].match(month) && this.matchers[5].match(dayOfWeek) && this.matchers[6].match(year);
    }

    private static boolean matchDayOfMonth(PartMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        return matcher instanceof DayOfMonthMatcher ? ((DayOfMonthMatcher)matcher).match(dayOfMonth, month, isLeapYear) : matcher.match(dayOfMonth);
    }

    public Calendar nextMatchAfter(int[] values, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.set(14, 0);
        int[] newValues = this.nextMatchValuesAfter(values);
        for (int i2 = 0; i2 < newValues.length; ++i2) {
            if (i2 == Part.DAY_OF_WEEK.ordinal()) continue;
            this.setValue(calendar, Part.of(i2), newValues[i2]);
        }
        return calendar;
    }

    private int[] nextMatchValuesAfter(int[] values) {
        int[] newValues = (int[])values.clone();
        int i2 = Part.YEAR.ordinal();
        int nextValue = 0;
        while (i2 >= 0) {
            if (i2 == Part.DAY_OF_WEEK.ordinal()) {
                --i2;
                continue;
            }
            nextValue = this.matchers[i2].nextAfter(values[i2]);
            if (nextValue > values[i2]) {
                newValues[i2] = nextValue;
                --i2;
                break;
            }
            if (nextValue < values[i2]) {
                ++i2;
                nextValue = -1;
                break;
            }
            --i2;
        }
        if (-1 == nextValue) {
            while (i2 <= Part.YEAR.ordinal()) {
                if (i2 == Part.DAY_OF_WEEK.ordinal()) {
                    ++i2;
                    continue;
                }
                nextValue = this.matchers[i2].nextAfter(values[i2] + 1);
                if (nextValue > values[i2]) {
                    newValues[i2] = nextValue;
                    --i2;
                    break;
                }
                ++i2;
            }
        }
        this.setToMin(newValues, i2);
        return newValues;
    }

    private void setToMin(int[] values, int toPart) {
        for (int i2 = 0; i2 <= toPart; ++i2) {
            Part part = Part.of(i2);
            values[i2] = this.getMin(part);
        }
    }

    private int getMin(Part part) {
        int min2;
        PartMatcher matcher = this.get(part);
        if (matcher instanceof AlwaysTrueMatcher) {
            min2 = part.getMin();
        } else if (matcher instanceof BoolArrayMatcher) {
            min2 = ((BoolArrayMatcher)matcher).getMinValue();
        } else {
            throw new IllegalArgumentException("Invalid matcher: " + matcher.getClass().getName());
        }
        return min2;
    }

    private Calendar setValue(Calendar calendar, Part part, int value) {
        switch (part) {
            case MONTH: {
                --value;
                break;
            }
            case DAY_OF_WEEK: {
                ++value;
            }
        }
        calendar.set(part.getCalendarField(), value);
        return calendar;
    }
}

