/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.xml;

import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import cn.hutool.json.XMLTokener;

public class JSONXMLParser {
    public static void parseJSONObject(JSONObject jo, String xmlStr, boolean keepStrings) throws JSONException {
        XMLTokener x2 = new XMLTokener(xmlStr, jo.getConfig());
        while (x2.more() && x2.skipPast("<")) {
            JSONXMLParser.parse(x2, jo, null, keepStrings);
        }
    }

    private static boolean parse(XMLTokener x2, JSONObject context, String name, boolean keepStrings) throws JSONException {
        String string;
        Object token = x2.nextToken();
        if (token == XML.BANG) {
            char c2 = x2.next();
            if (c2 == '-') {
                if (x2.next() == '-') {
                    x2.skipPast("-->");
                    return false;
                }
                x2.back();
            } else if (c2 == '[') {
                token = x2.nextToken();
                if ("CDATA".equals(token) && x2.next() == '[') {
                    String string2 = x2.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x2.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((token = x2.nextMeta()) == null) {
                    throw x2.syntaxError("Missing '>' after '<!'.");
                }
                if (token == XML.LT) {
                    ++i2;
                    continue;
                }
                if (token != XML.GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (token == XML.QUEST) {
            x2.skipPast("?>");
            return false;
        }
        if (token == XML.SLASH) {
            token = x2.nextToken();
            if (name == null) {
                throw x2.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x2.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x2.nextToken() != XML.GT) {
                throw x2.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x2.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonobject = new JSONObject();
        while (true) {
            if (token == null) {
                token = x2.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x2.nextToken();
            if (token == XML.EQ) {
                token = x2.nextToken();
                if (!(token instanceof String)) {
                    throw x2.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, keepStrings ? token : InternalJSONUtil.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == XML.SLASH) {
            if (x2.nextToken() != XML.GT) {
                throw x2.syntaxError("Misshaped tag");
            }
            if (jsonobject.size() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token == XML.GT) {
            while (true) {
                if ((token = x2.nextContent()) == null) {
                    if (tagName != null) {
                        throw x2.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.accumulate("content", keepStrings ? token : InternalJSONUtil.stringToValue(string));
                    continue;
                }
                if (token == XML.LT && JSONXMLParser.parse(x2, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.size() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                context.accumulate(tagName, jsonobject.get("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x2.syntaxError("Misshaped tag");
    }
}

