/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.socket.SocketRuntimeException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;

public class ChannelUtil {
    public static AsynchronousChannelGroup createFixedGroup(int poolSize) {
        try {
            return AsynchronousChannelGroup.withFixedThreadPool(poolSize, ThreadFactoryBuilder.create().setNamePrefix("Huool-socket-").build());
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static AsynchronousSocketChannel connect(AsynchronousChannelGroup group, InetSocketAddress address) {
        AsynchronousSocketChannel channel;
        try {
            channel = AsynchronousSocketChannel.open(group);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        try {
            channel.connect(address).get();
        }
        catch (InterruptedException | ExecutionException e3) {
            IoUtil.close(channel);
            throw new SocketRuntimeException(e3);
        }
        return channel;
    }
}

