/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DeclareType;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DeclareStatementDeParser
extends AbstractDeParser<DeclareStatement> {
    private ExpressionVisitor expressionVisitor;

    public DeclareStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(DeclareStatement declare) {
        this.buffer.append("DECLARE ");
        if (declare.getUserVariable() != null) {
            declare.getUserVariable().accept(this.expressionVisitor);
        }
        if (declare.getType() == DeclareType.AS) {
            this.buffer.append(" AS ");
            this.buffer.append(declare.getTypeName());
            return;
        }
        if (declare.getType() == DeclareType.TABLE) {
            this.buffer.append(" TABLE (");
            for (int i2 = 0; i2 < declare.getColumnDefinitions().size(); ++i2) {
                if (i2 > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(declare.getColumnDefinitions().get(i2).toString());
            }
            this.buffer.append(")");
        } else if (declare.getTypeDefinitions() != null) {
            for (int i3 = 0; i3 < declare.getTypeDefinitions().size(); ++i3) {
                if (i3 > 0) {
                    this.buffer.append(", ");
                }
                DeclareStatement.TypeDefExpr type = declare.getTypeDefinitions().get(i3);
                if (type.userVariable != null) {
                    type.userVariable.accept(this.expressionVisitor);
                    this.buffer.append(" ");
                }
                this.buffer.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                this.buffer.append(" = ");
                type.defaultExpr.accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

