/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation;

import java.util.function.Consumer;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.util.validation.ParseException;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationContext;
import net.sf.jsqlparser.util.validation.ValidationException;

final class ParseCapability
implements ValidationCapability {
    public static final String NAME = "parsing";
    private String statements;
    private Statements parsedStatement;

    public ParseCapability(String statements) {
        this.statements = statements;
    }

    public String getStatements() {
        return this.statements;
    }

    public Statements getParsedStatements() {
        return this.parsedStatement;
    }

    @Override
    public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        try {
            this.parsedStatement = CCJSqlParserUtil.parseStatements(CCJSqlParserUtil.newParser(this.statements).withConfiguration(context.getConfiguration()));
        }
        catch (JSQLParserException e2) {
            errorConsumer.accept(new ParseException("Cannot parse statement: " + e2.getMessage(), e2));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

