/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.hash;

import cn.hutool.core.lang.hash.Number128;
import cn.hutool.core.util.ByteUtil;
import java.util.Arrays;

public class CityHash {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long kMul = -7070675565921424023L;
    private static final int c1 = -862048943;
    private static final int c2 = 461845907;

    public static int hash32(byte[] data) {
        int g2;
        int len = data.length;
        if (len <= 24) {
            return len <= 12 ? (len <= 4 ? CityHash.hash32Len0to4(data) : CityHash.hash32Len5to12(data)) : CityHash.hash32Len13to24(data);
        }
        int h2 = len;
        int f2 = g2 = -862048943 * len;
        int a0 = CityHash.rotate32(CityHash.fetch32(data, len - 4) * -862048943, 17) * 461845907;
        int a1 = CityHash.rotate32(CityHash.fetch32(data, len - 8) * -862048943, 17) * 461845907;
        int a2 = CityHash.rotate32(CityHash.fetch32(data, len - 16) * -862048943, 17) * 461845907;
        int a3 = CityHash.rotate32(CityHash.fetch32(data, len - 12) * -862048943, 17) * 461845907;
        int a4 = CityHash.rotate32(CityHash.fetch32(data, len - 20) * -862048943, 17) * 461845907;
        h2 ^= a0;
        h2 = CityHash.rotate32(h2, 19);
        h2 = h2 * 5 + -430675100;
        h2 ^= a2;
        h2 = CityHash.rotate32(h2, 19);
        h2 = h2 * 5 + -430675100;
        g2 ^= a1;
        g2 = CityHash.rotate32(g2, 19);
        g2 = g2 * 5 + -430675100;
        g2 ^= a3;
        g2 = CityHash.rotate32(g2, 19);
        g2 = g2 * 5 + -430675100;
        f2 += a4;
        f2 = CityHash.rotate32(f2, 19);
        f2 = f2 * 5 + -430675100;
        int iters = (len - 1) / 20;
        int pos = 0;
        do {
            a0 = CityHash.rotate32(CityHash.fetch32(data, pos) * -862048943, 17) * 461845907;
            a1 = CityHash.fetch32(data, pos + 4);
            a2 = CityHash.rotate32(CityHash.fetch32(data, pos + 8) * -862048943, 17) * 461845907;
            a3 = CityHash.rotate32(CityHash.fetch32(data, pos + 12) * -862048943, 17) * 461845907;
            a4 = CityHash.fetch32(data, pos + 16);
            h2 ^= a0;
            h2 = CityHash.rotate32(h2, 18);
            h2 = h2 * 5 + -430675100;
            f2 += a1;
            f2 = CityHash.rotate32(f2, 19);
            f2 *= -862048943;
            g2 += a2;
            g2 = CityHash.rotate32(g2, 18);
            g2 = g2 * 5 + -430675100;
            h2 ^= a3 + a1;
            h2 = CityHash.rotate32(h2, 19);
            h2 = h2 * 5 + -430675100;
            g2 ^= a4;
            g2 = Integer.reverseBytes(g2) * 5;
            h2 += a4 * 5;
            h2 = Integer.reverseBytes(h2);
            int swapValue = f2 += a0;
            f2 = g2;
            g2 = h2;
            h2 = swapValue;
            pos += 20;
        } while (--iters != 0);
        g2 = CityHash.rotate32(g2, 11) * -862048943;
        g2 = CityHash.rotate32(g2, 17) * -862048943;
        f2 = CityHash.rotate32(f2, 11) * -862048943;
        f2 = CityHash.rotate32(f2, 17) * -862048943;
        h2 = CityHash.rotate32(h2 + g2, 19);
        h2 = h2 * 5 + -430675100;
        h2 = CityHash.rotate32(h2, 17) * -862048943;
        h2 = CityHash.rotate32(h2 + f2, 19);
        h2 = h2 * 5 + -430675100;
        h2 = CityHash.rotate32(h2, 17) * -862048943;
        return h2;
    }

    public static long hash64(byte[] data) {
        int len = data.length;
        if (len <= 32) {
            if (len <= 16) {
                return CityHash.hashLen0to16(data);
            }
            return CityHash.hashLen17to32(data);
        }
        if (len <= 64) {
            return CityHash.hashLen33to64(data);
        }
        long x2 = CityHash.fetch64(data, len - 40);
        long y2 = CityHash.fetch64(data, len - 16) + CityHash.fetch64(data, len - 56);
        long z2 = CityHash.hashLen16(CityHash.fetch64(data, len - 48) + (long)len, CityHash.fetch64(data, len - 24));
        Number128 v2 = CityHash.weakHashLen32WithSeeds(data, len - 64, len, z2);
        Number128 w2 = CityHash.weakHashLen32WithSeeds(data, len - 32, y2 + -5435081209227447693L, x2);
        x2 = x2 * -5435081209227447693L + CityHash.fetch64(data, 0);
        len = len - 1 & 0xFFFFFFC0;
        int pos = 0;
        do {
            x2 = CityHash.rotate64(x2 + y2 + v2.getLowValue() + CityHash.fetch64(data, pos + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate64(y2 + v2.getHighValue() + CityHash.fetch64(data, pos + 48), 42) * -5435081209227447693L;
            z2 = CityHash.rotate64(z2 + w2.getLowValue(), 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(data, pos, v2.getHighValue() * -5435081209227447693L, (x2 ^= w2.getHighValue()) + w2.getLowValue());
            w2 = CityHash.weakHashLen32WithSeeds(data, pos + 32, z2 + w2.getHighValue(), (y2 += v2.getLowValue() + CityHash.fetch64(data, pos + 40)) + CityHash.fetch64(data, pos + 16));
            long swapValue = x2;
            x2 = z2;
            z2 = swapValue;
            pos += 64;
        } while ((len -= 64) != 0);
        return CityHash.hashLen16(CityHash.hashLen16(v2.getLowValue(), w2.getLowValue()) + CityHash.shiftMix(y2) * -5435081209227447693L + z2, CityHash.hashLen16(v2.getHighValue(), w2.getHighValue()) + x2);
    }

    public static long hash64(byte[] data, long seed0, long seed1) {
        return CityHash.hashLen16(CityHash.hash64(data) - seed0, seed1);
    }

    public static long hash64(byte[] data, long seed) {
        return CityHash.hash64(data, -7286425919675154353L, seed);
    }

    public static Number128 hash128(byte[] data) {
        int len = data.length;
        return len >= 16 ? CityHash.hash128(data, 16, new Number128(CityHash.fetch64(data, 0), CityHash.fetch64(data, 8) + -4348849565147123417L)) : CityHash.hash128(data, 0, new Number128(-4348849565147123417L, -5435081209227447693L));
    }

    public static Number128 hash128(byte[] data, Number128 seed) {
        return CityHash.hash128(data, 0, seed);
    }

    private static Number128 hash128(byte[] byteArray, int start, Number128 seed) {
        int len = byteArray.length - start;
        if (len < 128) {
            return CityHash.cityMurmur(Arrays.copyOfRange(byteArray, start, byteArray.length), seed);
        }
        Number128 v2 = new Number128(0L, 0L);
        Number128 w2 = new Number128(0L, 0L);
        long x2 = seed.getLowValue();
        long y2 = seed.getHighValue();
        long z2 = (long)len * -5435081209227447693L;
        v2.setLowValue(CityHash.rotate64(y2 ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + CityHash.fetch64(byteArray, start));
        v2.setHighValue(CityHash.rotate64(v2.getLowValue(), 42) * -5435081209227447693L + CityHash.fetch64(byteArray, start + 8));
        w2.setLowValue(CityHash.rotate64(y2 + z2, 35) * -5435081209227447693L + x2);
        w2.setHighValue(CityHash.rotate64(x2 + CityHash.fetch64(byteArray, start + 88), 53) * -5435081209227447693L);
        int pos = start;
        do {
            x2 = CityHash.rotate64(x2 + y2 + v2.getLowValue() + CityHash.fetch64(byteArray, pos + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate64(y2 + v2.getHighValue() + CityHash.fetch64(byteArray, pos + 48), 42) * -5435081209227447693L;
            y2 += v2.getLowValue() + CityHash.fetch64(byteArray, pos + 40);
            z2 = CityHash.rotate64(z2 + w2.getLowValue(), 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(byteArray, pos, v2.getHighValue() * -5435081209227447693L, (x2 ^= w2.getHighValue()) + w2.getLowValue());
            w2 = CityHash.weakHashLen32WithSeeds(byteArray, pos + 32, z2 + w2.getHighValue(), y2 + CityHash.fetch64(byteArray, pos + 16));
            long swapValue = x2;
            x2 = z2;
            z2 = swapValue;
            x2 = CityHash.rotate64(x2 + y2 + v2.getLowValue() + CityHash.fetch64(byteArray, (pos += 64) + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate64(y2 + v2.getHighValue() + CityHash.fetch64(byteArray, pos + 48), 42) * -5435081209227447693L;
            y2 += v2.getLowValue() + CityHash.fetch64(byteArray, pos + 40);
            z2 = CityHash.rotate64(z2 + w2.getLowValue(), 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(byteArray, pos, v2.getHighValue() * -5435081209227447693L, (x2 ^= w2.getHighValue()) + w2.getLowValue());
            w2 = CityHash.weakHashLen32WithSeeds(byteArray, pos + 32, z2 + w2.getHighValue(), y2 + CityHash.fetch64(byteArray, pos + 16));
            swapValue = x2;
            x2 = z2;
            z2 = swapValue;
            pos += 64;
        } while ((len -= 128) >= 128);
        x2 += CityHash.rotate64(v2.getLowValue() + z2, 49) * -4348849565147123417L;
        y2 = y2 * -4348849565147123417L + CityHash.rotate64(w2.getHighValue(), 37);
        z2 = z2 * -4348849565147123417L + CityHash.rotate64(w2.getLowValue(), 27);
        w2.setLowValue(w2.getLowValue() * 9L);
        v2.setLowValue(v2.getLowValue() * -4348849565147123417L);
        int tail_done = 0;
        while (tail_done < len) {
            y2 = CityHash.rotate64(x2 + y2, 42) * -4348849565147123417L + v2.getHighValue();
            w2.setLowValue(w2.getLowValue() + CityHash.fetch64(byteArray, pos + len - (tail_done += 32) + 16));
            x2 = x2 * -4348849565147123417L + w2.getLowValue();
            w2.setHighValue(w2.getHighValue() + v2.getLowValue());
            v2 = CityHash.weakHashLen32WithSeeds(byteArray, pos + len - tail_done, v2.getLowValue() + (z2 += w2.getHighValue() + CityHash.fetch64(byteArray, pos + len - tail_done)), v2.getHighValue());
            v2.setLowValue(v2.getLowValue() * -4348849565147123417L);
        }
        x2 = CityHash.hashLen16(x2, v2.getLowValue());
        y2 = CityHash.hashLen16(y2 + z2, w2.getLowValue());
        return new Number128(CityHash.hashLen16(x2 + v2.getHighValue(), w2.getHighValue()) + y2, CityHash.hashLen16(x2 + w2.getHighValue(), y2 + v2.getHighValue()));
    }

    private static int hash32Len0to4(byte[] byteArray) {
        int b2 = 0;
        int c2 = 9;
        int len = byteArray.length;
        for (byte v2 : byteArray) {
            b2 = b2 * -862048943 + v2;
            c2 ^= b2;
        }
        return CityHash.fmix(CityHash.mur(b2, CityHash.mur(len, c2)));
    }

    private static int hash32Len5to12(byte[] byteArray) {
        int len;
        int a2 = len = byteArray.length;
        int b2 = len * 5;
        int c2 = 9;
        int d2 = b2;
        return CityHash.fmix(CityHash.mur(c2 += CityHash.fetch32(byteArray, len >>> 1 & 4), CityHash.mur(b2 += CityHash.fetch32(byteArray, len - 4), CityHash.mur(a2 += CityHash.fetch32(byteArray, 0), d2))));
    }

    private static int hash32Len13to24(byte[] byteArray) {
        int len = byteArray.length;
        int a2 = CityHash.fetch32(byteArray, (len >>> 1) - 4);
        int b2 = CityHash.fetch32(byteArray, 4);
        int c2 = CityHash.fetch32(byteArray, len - 8);
        int d2 = CityHash.fetch32(byteArray, len >>> 1);
        int e2 = CityHash.fetch32(byteArray, 0);
        int f2 = CityHash.fetch32(byteArray, len - 4);
        int h2 = len;
        return CityHash.fmix(CityHash.mur(f2, CityHash.mur(e2, CityHash.mur(d2, CityHash.mur(c2, CityHash.mur(b2, CityHash.mur(a2, h2)))))));
    }

    private static long hashLen0to16(byte[] byteArray) {
        int len = byteArray.length;
        if (len >= 8) {
            long mul = -7286425919675154353L + (long)len * 2L;
            long a2 = CityHash.fetch64(byteArray, 0) + -7286425919675154353L;
            long b2 = CityHash.fetch64(byteArray, len - 8);
            long c2 = CityHash.rotate64(b2, 37) * mul + a2;
            long d2 = (CityHash.rotate64(a2, 25) + b2) * mul;
            return CityHash.hashLen16(c2, d2, mul);
        }
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len * 2);
            long a3 = (long)CityHash.fetch32(byteArray, 0) & 0xFFFFFFFFL;
            return CityHash.hashLen16((long)len + (a3 << 3), (long)CityHash.fetch32(byteArray, len - 4) & 0xFFFFFFFFL, mul);
        }
        if (len > 0) {
            int a4 = byteArray[0] & 0xFF;
            int b3 = byteArray[len >>> 1] & 0xFF;
            int c3 = byteArray[len - 1] & 0xFF;
            int y2 = a4 + (b3 << 8);
            int z2 = len + (c3 << 2);
            return CityHash.shiftMix((long)y2 * -7286425919675154353L ^ (long)z2 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLen17to32(byte[] byteArray) {
        int len = byteArray.length;
        long mul = -7286425919675154353L + (long)len * 2L;
        long a2 = CityHash.fetch64(byteArray, 0) * -5435081209227447693L;
        long b2 = CityHash.fetch64(byteArray, 8);
        long c2 = CityHash.fetch64(byteArray, len - 8) * mul;
        long d2 = CityHash.fetch64(byteArray, len - 16) * -7286425919675154353L;
        return CityHash.hashLen16(CityHash.rotate64(a2 + b2, 43) + CityHash.rotate64(c2, 30) + d2, a2 + CityHash.rotate64(b2 + -7286425919675154353L, 18) + c2, mul);
    }

    private static long hashLen33to64(byte[] byteArray) {
        int len = byteArray.length;
        long mul = -7286425919675154353L + (long)len * 2L;
        long a2 = CityHash.fetch64(byteArray, 0) * -7286425919675154353L;
        long b2 = CityHash.fetch64(byteArray, 8);
        long c2 = CityHash.fetch64(byteArray, len - 24);
        long d2 = CityHash.fetch64(byteArray, len - 32);
        long e2 = CityHash.fetch64(byteArray, 16) * -7286425919675154353L;
        long f2 = CityHash.fetch64(byteArray, 24) * 9L;
        long g2 = CityHash.fetch64(byteArray, len - 8);
        long h2 = CityHash.fetch64(byteArray, len - 16) * mul;
        long u2 = CityHash.rotate64(a2 + g2, 43) + (CityHash.rotate64(b2, 30) + c2) * 9L;
        long v2 = (a2 + g2 ^ d2) + f2 + 1L;
        long w2 = Long.reverseBytes((u2 + v2) * mul) + h2;
        long x2 = CityHash.rotate64(e2 + f2, 42) + c2;
        long y2 = (Long.reverseBytes((v2 + w2) * mul) + g2) * mul;
        long z2 = e2 + f2 + c2;
        a2 = Long.reverseBytes((x2 + z2) * mul + y2) + b2;
        b2 = CityHash.shiftMix((z2 + a2) * mul + d2 + h2) * mul;
        return b2 + x2;
    }

    private static long fetch64(byte[] byteArray, int start) {
        return ByteUtil.bytesToLong(byteArray, start, ByteUtil.CPU_ENDIAN);
    }

    private static int fetch32(byte[] byteArray, int start) {
        return ByteUtil.bytesToInt(byteArray, start, ByteUtil.CPU_ENDIAN);
    }

    private static long rotate64(long val, int shift) {
        return shift == 0 ? val : val >>> shift | val << 64 - shift;
    }

    private static int rotate32(int val, int shift) {
        return shift == 0 ? val : val >>> shift | val << 32 - shift;
    }

    private static long hashLen16(long u2, long v2, long mul) {
        long a2 = (u2 ^ v2) * mul;
        a2 ^= a2 >>> 47;
        long b2 = (v2 ^ a2) * mul;
        b2 ^= b2 >>> 47;
        return b2 *= mul;
    }

    private static long hashLen16(long u2, long v2) {
        return CityHash.hash128to64(new Number128(u2, v2));
    }

    private static long hash128to64(Number128 number128) {
        long a2 = (number128.getLowValue() ^ number128.getHighValue()) * -7070675565921424023L;
        a2 ^= a2 >>> 47;
        long b2 = (number128.getHighValue() ^ a2) * -7070675565921424023L;
        b2 ^= b2 >>> 47;
        return b2 *= -7070675565921424023L;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static int fmix(int h2) {
        h2 ^= h2 >>> 16;
        h2 *= -2048144789;
        h2 ^= h2 >>> 13;
        h2 *= -1028477387;
        h2 ^= h2 >>> 16;
        return h2;
    }

    private static int mur(int a2, int h2) {
        a2 *= -862048943;
        a2 = CityHash.rotate32(a2, 17);
        h2 ^= (a2 *= 461845907);
        h2 = CityHash.rotate32(h2, 19);
        return h2 * 5 + -430675100;
    }

    private static Number128 weakHashLen32WithSeeds(long w2, long x2, long y2, long z2, long a2, long b2) {
        b2 = CityHash.rotate64(b2 + (a2 += w2) + z2, 21);
        long c2 = a2;
        a2 += x2;
        return new Number128(a2 + z2, (b2 += CityHash.rotate64(a2 += y2, 44)) + c2);
    }

    private static Number128 weakHashLen32WithSeeds(byte[] byteArray, int start, long a2, long b2) {
        return CityHash.weakHashLen32WithSeeds(CityHash.fetch64(byteArray, start), CityHash.fetch64(byteArray, start + 8), CityHash.fetch64(byteArray, start + 16), CityHash.fetch64(byteArray, start + 24), a2, b2);
    }

    private static Number128 cityMurmur(byte[] byteArray, Number128 seed) {
        long d2;
        long c2;
        int len = byteArray.length;
        long a2 = seed.getLowValue();
        long b2 = seed.getHighValue();
        int l2 = len - 16;
        if (l2 <= 0) {
            a2 = CityHash.shiftMix(a2 * -5435081209227447693L) * -5435081209227447693L;
            c2 = b2 * -5435081209227447693L + CityHash.hashLen0to16(byteArray);
            d2 = CityHash.shiftMix(a2 + (len >= 8 ? CityHash.fetch64(byteArray, 0) : c2));
        } else {
            c2 = CityHash.hashLen16(CityHash.fetch64(byteArray, len - 8) + -5435081209227447693L, a2);
            d2 = CityHash.hashLen16(b2 + (long)len, c2 + CityHash.fetch64(byteArray, len - 16));
            a2 += d2;
            int pos = 0;
            do {
                a2 ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos) * -5435081209227447693L) * -5435081209227447693L;
                b2 ^= (a2 *= -5435081209227447693L);
                c2 ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos + 8) * -5435081209227447693L) * -5435081209227447693L;
                d2 ^= (c2 *= -5435081209227447693L);
                pos += 16;
            } while ((l2 -= 16) > 0);
        }
        a2 = CityHash.hashLen16(a2, c2);
        b2 = CityHash.hashLen16(d2, b2);
        return new Number128(a2 ^ b2, CityHash.hashLen16(b2, a2));
    }
}

