/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;

public class NamingCase {
    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toSymbolCase(str, '_');
    }

    public static String toKebabCase(CharSequence str) {
        return NamingCase.toSymbolCase(str, '-');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StrBuilder sb = new StrBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = str.charAt(i2);
            if (Character.isUpperCase(c2)) {
                Character nextChar;
                Character preChar = i2 > 0 ? Character.valueOf(str.charAt(i2 - 1)) : null;
                Character c3 = nextChar = i2 < str.length() - 1 ? Character.valueOf(str.charAt(i2 + 1)) : null;
                if (null != preChar) {
                    if (symbol == preChar.charValue()) {
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                            c2 = Character.toLowerCase(c2);
                        }
                    } else if (Character.isLowerCase(preChar.charValue())) {
                        sb.append(symbol);
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue()) || CharUtil.isNumber(nextChar.charValue())) {
                            c2 = Character.toLowerCase(c2);
                        }
                    } else if (null != nextChar && Character.isLowerCase(nextChar.charValue())) {
                        sb.append(symbol);
                        c2 = Character.toLowerCase(c2);
                    }
                } else if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                    c2 = Character.toLowerCase(c2);
                }
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public static String toPascalCase(CharSequence name) {
        return StrUtil.upperFirst(NamingCase.toCamelCase(name));
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name, '_');
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (StrUtil.contains((CharSequence)name2, symbol)) {
            int length = name2.length();
            StringBuilder sb = new StringBuilder(length);
            boolean upperCase = false;
            for (int i2 = 0; i2 < length; ++i2) {
                char c2 = name2.charAt(i2);
                if (c2 == symbol) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c2));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c2));
            }
            return sb.toString();
        }
        return name2;
    }
}

