/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

public class Vigenere {
    public static String encrypt(CharSequence data, CharSequence cipherKey) {
        int dataLen = data.length();
        int cipherKeyLen = cipherKey.length();
        char[] cipherArray = new char[dataLen];
        for (int i2 = 0; i2 < dataLen / cipherKeyLen + 1; ++i2) {
            for (int t2 = 0; t2 < cipherKeyLen; ++t2) {
                if (t2 + i2 * cipherKeyLen >= dataLen) continue;
                char dataChar = data.charAt(t2 + i2 * cipherKeyLen);
                char cipherKeyChar = cipherKey.charAt(t2);
                cipherArray[t2 + i2 * cipherKeyLen] = (char)((dataChar + cipherKeyChar - 64) % 95 + 32);
            }
        }
        return String.valueOf(cipherArray);
    }

    public static String decrypt(CharSequence data, CharSequence cipherKey) {
        int dataLen = data.length();
        int cipherKeyLen = cipherKey.length();
        char[] clearArray = new char[dataLen];
        for (int i2 = 0; i2 < dataLen; ++i2) {
            for (int t2 = 0; t2 < cipherKeyLen; ++t2) {
                char cipherKeyChar;
                if (t2 + i2 * cipherKeyLen >= dataLen) continue;
                char dataChar = data.charAt(t2 + i2 * cipherKeyLen);
                clearArray[t2 + i2 * cipherKeyLen] = dataChar - (cipherKeyChar = cipherKey.charAt(t2)) >= 0 ? (char)((dataChar - cipherKeyChar) % 95 + 32) : (char)((dataChar - cipherKeyChar + 95) % 95 + 32);
            }
        }
        return String.valueOf(clearArray);
    }
}

