/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONTokener;

public class JSONParser {
    private final JSONTokener tokener;

    public static JSONParser of(JSONTokener tokener) {
        return new JSONParser(tokener);
    }

    public JSONParser(JSONTokener tokener) {
        this.tokener = tokener;
    }

    public void parseTo(JSONObject jsonObject, Filter<MutablePair<String, Object>> filter) {
        JSONTokener tokener = this.tokener;
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block9: while (true) {
            char prev = tokener.getPrevious();
            char c2 = tokener.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
                case '[': 
                case '{': {
                    if (prev != '{') break;
                    throw tokener.syntaxError("A JSONObject can not directly nest another JSONObject or JSONArray.");
                }
            }
            tokener.back();
            String key = tokener.nextValue().toString();
            c2 = tokener.nextClean();
            if (c2 != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            jsonObject.set(key, tokener.nextValue(), filter, jsonObject.getConfig().isCheckDuplicate());
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block9;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    public void parseTo(JSONArray jsonArray, Filter<Mutable<Object>> filter) {
        JSONTokener x2 = this.tokener;
        if (x2.nextClean() != '[') {
            throw x2.syntaxError("A JSONArray text must start with '['");
        }
        if (x2.nextClean() != ']') {
            x2.back();
            block4: while (true) {
                if (x2.nextClean() == ',') {
                    x2.back();
                    jsonArray.addRaw(JSONNull.NULL, filter);
                } else {
                    x2.back();
                    jsonArray.addRaw(x2.nextValue(), filter);
                }
                switch (x2.nextClean()) {
                    case ',': {
                        if (x2.nextClean() == ']') {
                            return;
                        }
                        x2.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x2.syntaxError("Expected a ',' or ']'");
        }
    }
}

