/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.override;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class MybatisMapperMethod {
    private final MapperMethod.SqlCommand command;
    private final MapperMethod.MethodSignature method;

    public MybatisMapperMethod(Class<?> mapperInterface, Method method, Configuration config) {
        this.command = new MapperMethod.SqlCommand(config, mapperInterface, method);
        this.method = new MapperMethod.MethodSignature(config, mapperInterface, method);
    }

    public Object execute(SqlSession sqlSession, Object[] args) {
        Optional<Object> result;
        switch (this.command.getType()) {
            case INSERT: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.insert(this.command.getName(), param));
                break;
            }
            case UPDATE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.update(this.command.getName(), param));
                break;
            }
            case DELETE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.delete(this.command.getName(), param));
                break;
            }
            case SELECT: {
                if (this.method.returnsVoid() && this.method.hasResultHandler()) {
                    this.executeWithResultHandler(sqlSession, args);
                    result = null;
                    break;
                }
                if (this.method.returnsMany()) {
                    result = this.executeForMany(sqlSession, args);
                    break;
                }
                if (this.method.returnsMap()) {
                    result = this.executeForMap(sqlSession, args);
                    break;
                }
                if (this.method.returnsCursor()) {
                    result = this.executeForCursor(sqlSession, args);
                    break;
                }
                if (IPage.class.isAssignableFrom(this.method.getReturnType())) {
                    result = this.executeForIPage(sqlSession, args);
                    break;
                }
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = sqlSession.selectOne(this.command.getName(), param);
                if (!this.method.returnsOptional() || result != null && this.method.getReturnType().equals(result.getClass())) break;
                result = Optional.ofNullable(result);
                break;
            }
            case FLUSH: {
                result = sqlSession.flushStatements();
                break;
            }
            default: {
                throw new BindingException("Unknown execution method for: " + this.command.getName());
            }
        }
        if (result == null && this.method.getReturnType().isPrimitive() && !this.method.returnsVoid()) {
            throw new BindingException("Mapper method '" + this.command.getName() + " attempted to return null from a method with a primitive return type (" + this.method.getReturnType() + ").");
        }
        return result;
    }

    private <E> Object executeForIPage(SqlSession sqlSession, Object[] args) {
        IPage result = null;
        for (Object arg : args) {
            if (!(arg instanceof IPage)) continue;
            result = (IPage)arg;
            break;
        }
        Assert.notNull(result, "can't found IPage for args!", new Object[0]);
        Object param = this.method.convertArgsToSqlCommandParam(args);
        List list = sqlSession.selectList(this.command.getName(), param);
        result.setRecords(list);
        return result;
    }

    private Object rowCountResult(int rowCount) {
        Constable result;
        if (this.method.returnsVoid()) {
            result = null;
        } else if (Integer.class.equals(this.method.getReturnType()) || Integer.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Long.class.equals(this.method.getReturnType()) || Long.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Boolean.class.equals(this.method.getReturnType()) || Boolean.TYPE.equals(this.method.getReturnType())) {
            result = Boolean.valueOf(rowCount > 0);
        } else {
            throw new BindingException("Mapper method '" + this.command.getName() + "' has an unsupported return type: " + this.method.getReturnType());
        }
        return result;
    }

    private void executeWithResultHandler(SqlSession sqlSession, Object[] args) {
        MappedStatement ms = sqlSession.getConfiguration().getMappedStatement(this.command.getName());
        if (!StatementType.CALLABLE.equals((Object)ms.getStatementType()) && Void.TYPE.equals(ms.getResultMaps().get(0).getType())) {
            throw new BindingException("method " + this.command.getName() + " needs either a @ResultMap annotation, a @ResultType annotation, or a resultType attribute in XML so a ResultHandler can be used as a parameter.");
        }
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            sqlSession.select(this.command.getName(), param, rowBounds, this.method.extractResultHandler(args));
        } else {
            sqlSession.select(this.command.getName(), param, this.method.extractResultHandler(args));
        }
    }

    private <E> Object executeForMany(SqlSession sqlSession, Object[] args) {
        List result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectList(this.command.getName(), param, rowBounds);
        } else {
            result = sqlSession.selectList(this.command.getName(), param);
        }
        if (!this.method.getReturnType().isAssignableFrom(result.getClass())) {
            if (this.method.getReturnType().isArray()) {
                return this.convertToArray(result);
            }
            return this.convertToDeclaredCollection(sqlSession.getConfiguration(), result);
        }
        return result;
    }

    private <T> Cursor<T> executeForCursor(SqlSession sqlSession, Object[] args) {
        Cursor result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectCursor(this.command.getName(), param, rowBounds);
        } else {
            result = sqlSession.selectCursor(this.command.getName(), param);
        }
        return result;
    }

    private <E> Object convertToDeclaredCollection(Configuration config, List<E> list) {
        Object collection = config.getObjectFactory().create(this.method.getReturnType());
        MetaObject metaObject = config.newMetaObject(collection);
        metaObject.addAll(list);
        return collection;
    }

    private <E> Object convertToArray(List<E> list) {
        Class<?> arrayComponentType = this.method.getReturnType().getComponentType();
        Object array = Array.newInstance(arrayComponentType, list.size());
        if (arrayComponentType.isPrimitive()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(array, i2, list.get(i2));
            }
            return array;
        }
        return list.toArray((Object[])array);
    }

    private <K, V> Map<K, V> executeForMap(SqlSession sqlSession, Object[] args) {
        Map result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey(), rowBounds);
        } else {
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey());
        }
        return result;
    }
}

